/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.breath;

import com.google.gson.annotations.SerializedName;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;

public class DragonBreathType {
    private String id;
    @SerializedName(value="colors")
    private List<String> colorHexCodes = new ArrayList<String>();
    @SerializedName(value="damage")
    private float damage = 2.0f;
    @SerializedName(value="fire_time")
    private int fireTime = 0;
    @SerializedName(value="particle_density")
    private int particleDensity = 3;
    @SerializedName(value="effects")
    private List<BreathEffect> effects = new ArrayList<BreathEffect>();

    public Component getName() {
        return Component.translatable((String)("dmr.dragon_breath." + this.getId()));
    }

    public List<Color> getGradient() {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String hex : this.colorHexCodes) {
            colors.add(Color.decode("#" + hex));
        }
        return colors;
    }

    public DamageSource getDamageSource(LivingEntity source) {
        return source.level().damageSources().dragonBreath();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public List<String> getColorHexCodes() {
        return this.colorHexCodes;
    }

    @Generated
    public float getDamage() {
        return this.damage;
    }

    @Generated
    public int getFireTime() {
        return this.fireTime;
    }

    @Generated
    public int getParticleDensity() {
        return this.particleDensity;
    }

    @Generated
    public List<BreathEffect> getEffects() {
        return this.effects;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    public static class BreathEffect {
        @SerializedName(value="effect")
        private String effectId;
        @SerializedName(value="duration")
        private int duration;
        @SerializedName(value="amplifier")
        private int amplifier;
        @SerializedName(value="chance")
        private float chance = 1.0f;

        @Generated
        public String getEffectId() {
            return this.effectId;
        }

        @Generated
        public int getDuration() {
            return this.duration;
        }

        @Generated
        public int getAmplifier() {
            return this.amplifier;
        }

        @Generated
        public float getChance() {
            return this.chance;
        }
    }
}

