/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.abilities.dragon_types.lush_dragon;

import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.abilities.types.FootprintAbility;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FloralTrailAbility
implements FootprintAbility {
    private static final int GRASS_LIGHT_THRESHOLD = 4;

    @Override
    public void placeFootprint(TameableDragonEntity dragon, BlockPos pos) {
        Level level = dragon.level;
        BlockPos groundPos = pos.below();
        BlockState steppingOn = level.getBlockState(groundPos);
        if (steppingOn.is(Blocks.DIRT) && level.getLightEmission(pos) >= 4) {
            level.setBlockAndUpdate(groundPos, Blocks.GRASS_BLOCK.defaultBlockState());
            return;
        }
        if (!level.getBlockState(pos).isAir()) {
            return;
        }
        BlockState placing = null;
        if (steppingOn.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
            placing = (level.getRandom().nextBoolean() ? Blocks.RED_MUSHROOM : Blocks.BROWN_MUSHROOM).defaultBlockState();
        } else if (steppingOn.is(BlockTags.DIRT)) {
            placing = level.registryAccess().registryOrThrow(Registries.BLOCK).getTag(BlockTags.SMALL_FLOWERS).flatMap(tag -> tag.getRandomElement(dragon.getRandom())).map(Holder::value).filter(b -> b != Blocks.WITHER_ROSE).orElse(Blocks.DANDELION).defaultBlockState();
        }
        if (placing != null && placing.canSurvive((LevelReader)level, pos)) {
            level.setBlockAndUpdate(pos, placing);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), dragon.getRandom().nextInt(4) + 2, 0.5, 0.5, 0.5, 1.0);
        }
    }

    @Override
    public String type() {
        return "floral_trail";
    }
}

