/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.abilities.dragon_types.fire_dragon;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.abilities.types.FootprintAbility;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class HotFeetAbility
implements FootprintAbility {
    public static final TagKey<Block> BURNABLES_TAG = BlockTags.create((ResourceLocation)DMR.id("hot_feet_burnables"));

    @Override
    public void placeFootprint(TameableDragonEntity dragon, BlockPos pos) {
        Level level = dragon.level;
        BlockState steppingOn = level.getBlockState(pos);
        if (steppingOn.is(BURNABLES_TAG)) {
            level.removeBlock(pos, false);
            level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, dragon.getSoundSource(), 0.1f, 2.0f);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0, 0.0, 1.0, 0.0, 0.05);
        }
    }

    @Override
    public String type() {
        return "hot_feet";
    }
}

