/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.recipes;

import dmr.DragonMounts.registry.DragonArmorRegistry;
import dmr.DragonMounts.registry.ModCustomRecipes;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.types.armor.DragonArmor;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class NetheriteArmorRecipe
extends CustomRecipe {
    public NetheriteArmorRecipe(CraftingBookCategory category) {
        super(category);
    }

    public NetheriteArmorRecipe() {
        super(CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingInput input, Level level) {
        boolean hasDiamondArmor = false;
        boolean hasNetheriteIngot = false;
        for (int i = 0; i < input.height(); ++i) {
            for (int j = 0; j < input.width(); ++j) {
                ItemStack itemstack = input.getItem(j, i);
                if (itemstack.isEmpty()) continue;
                boolean isArmor = false;
                boolean isIngot = false;
                if (itemstack.is(ModItems.DRAGON_ARMOR.get()) && DragonArmor.getArmorType(itemstack) == DragonArmorRegistry.getDragonArmor("diamond")) {
                    isArmor = true;
                }
                if (itemstack.is(Items.NETHERITE_INGOT)) {
                    isIngot = true;
                }
                if (isArmor && hasDiamondArmor || isIngot && hasNetheriteIngot) {
                    return false;
                }
                if (!isIngot && !isArmor) {
                    return false;
                }
                if (isArmor) {
                    hasDiamondArmor = true;
                }
                if (!isIngot) continue;
                hasNetheriteIngot = true;
            }
        }
        return hasDiamondArmor && hasNetheriteIngot;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack result = new ItemStack((ItemLike)ModItems.DRAGON_ARMOR.get());
        DragonArmor.setArmorType(result, DragonArmorRegistry.getDragonArmor("netherite"));
        return result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 || height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModCustomRecipes.NETHERITE_ARMOR_RECIPE.get();
    }
}

