/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.items;

import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModComponents;
import dmr.DragonMounts.registry.ModEntities;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.types.dragonBreeds.DragonHybridBreed;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;

public class DragonSpawnEgg
extends DeferredSpawnEggItem {
    public static final String DATA_ITEM_NAME = "ItemName";
    public static final String DATA_PRIM_COLOR = "PrimaryColor";
    public static final String DATA_SEC_COLOR = "SecondaryColor";

    public DragonSpawnEgg() {
        super(ModEntities.DRAGON_ENTITY, 0, 0, new Item.Properties());
    }

    public static ItemStack create(IDragonBreed breed) {
        return DragonSpawnEgg.create(breed, null);
    }

    public static ItemStack create(IDragonBreed breed, IDragonBreed.Variant variant) {
        String id = breed.getId();
        ItemStack stack = new ItemStack((ItemLike)ModItems.DRAGON_SPAWN_EGG.get());
        CompoundTag entityTag = new CompoundTag();
        if (variant != null) {
            entityTag.putString("variant", variant.id());
        }
        entityTag.putString("breed", id);
        entityTag.putString("id", "dmr:dragon");
        CompoundTag itemDataTag = new CompoundTag();
        if (variant != null) {
            itemDataTag.putString(DATA_ITEM_NAME, String.join((CharSequence)".", ModItems.DRAGON_SPAWN_EGG.get().getDescriptionId(), id + "$" + variant.id()));
            itemDataTag.putInt(DATA_PRIM_COLOR, variant.getPrimaryColor());
            itemDataTag.putInt(DATA_SEC_COLOR, variant.getSecondaryColor());
        } else {
            itemDataTag.putString(DATA_ITEM_NAME, String.join((CharSequence)".", ModItems.DRAGON_SPAWN_EGG.get().getDescriptionId(), id));
            itemDataTag.putInt(DATA_PRIM_COLOR, breed.getPrimaryColor());
            itemDataTag.putInt(DATA_SEC_COLOR, breed.getSecondaryColor());
        }
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)itemDataTag));
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityTag));
        stack.set(ModComponents.DRAGON_BREED, (Object)id);
        stack.set(ModComponents.DRAGON_VARIANT, (Object)(variant != null ? variant.id() : null));
        return stack;
    }

    public Component getName(ItemStack stack) {
        IDragonBreed breed;
        if (stack.has(ModComponents.DRAGON_BREED) && (breed = DragonBreedsRegistry.getDragonBreed((String)stack.get(ModComponents.DRAGON_BREED))) instanceof DragonHybridBreed) {
            DragonHybridBreed hybridBreed = (DragonHybridBreed)breed;
            String par1 = hybridBreed.parent1.getName().getString();
            String par2 = hybridBreed.parent2.getName().getString();
            String langKey = String.join((CharSequence)".", ModItems.DRAGON_SPAWN_EGG.get().getDescriptionId(), "hybrid");
            return Component.translatable((String)langKey, (Object[])new Object[]{par1, par2});
        }
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (tag.contains(DATA_ITEM_NAME)) {
            return Component.translatable((String)tag.getString(DATA_ITEM_NAME));
        }
        return super.getName(stack);
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (customData == CustomData.EMPTY || !tag.contains(DATA_PRIM_COLOR) || !tag.contains(DATA_SEC_COLOR)) {
            IDragonBreed breed = DragonBreedsRegistry.getDragonBreed((String)stack.get(ModComponents.DRAGON_BREED));
            return tintIndex == 0 ? breed.getPrimaryColor() : breed.getSecondaryColor();
        }
        return tintIndex == 0 ? tag.getInt(DATA_PRIM_COLOR) : tag.getInt(DATA_SEC_COLOR);
    }
}

