/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.server.entity.dragon.DragonAudioComponent;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.util.BreedingUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

abstract class DragonSpawnComponent
extends DragonAudioComponent {
    private UUID spawnGroupId;

    protected DragonSpawnComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isNaturalSpawn() {
        return this.spawnGroupId != null;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getSpawnGroupId() != null) {
            compound.putUUID("spawnGroupId", this.getSpawnGroupId());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("spawnGroupId")) {
            this.setSpawnGroupId(compound.getUUID("spawnGroupId"));
        }
    }

    public static boolean checkDragonSpawnRules(EntityType<TameableDragonEntity> entityType, ServerLevelAccessor accessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (random.nextFloat() > 0.05f) {
            return false;
        }
        ServerLevel level = accessor.getLevel();
        List<Map.Entry<Integer, IDragonBreed>> outcomes = BreedingUtils.getHabitatBreedOutcomes(level, pos);
        return !outcomes.isEmpty() && outcomes.stream().anyMatch(s -> (Integer)s.getKey() > 3);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        ServerLevel level = accessor.getLevel();
        if (spawnGroupData instanceof DragonGroupData) {
            DragonGroupData data = (DragonGroupData)((Object)spawnGroupData);
            this.setBreed(data.breed);
            this.setSpawnGroupId(data.groupId);
            this.setBaby(true);
            if (!this.breed.getVariants().isEmpty() && this.random.nextFloat() < 0.2f) {
                IDragonBreed.Variant variant = this.breed.getVariants().get(this.random.nextInt(this.breed.getVariants().size()));
                this.setVariant(variant.id());
            }
        } else {
            Optional highestOutcome;
            List<Map.Entry<Integer, IDragonBreed>> outcomes = BreedingUtils.getHabitatBreedOutcomes(level, this.blockPosition());
            if (!outcomes.isEmpty() && (highestOutcome = outcomes.stream().max(Map.Entry.comparingByKey())).isPresent()) {
                List<Map.Entry> breeds = outcomes.stream().filter(s -> Objects.equals(s.getKey(), ((Map.Entry)highestOutcome.get()).getKey())).toList();
                IDragonBreed breed = (IDragonBreed)breeds.get(this.random.nextInt(breeds.size())).getValue();
                IDragonBreed.Variant variant = null;
                this.setBreed(breed);
                if (!breed.getVariants().isEmpty() && this.random.nextFloat() < 0.2f) {
                    variant = breed.getVariants().get(this.random.nextInt(breed.getVariants().size()));
                    this.setVariant(variant.id());
                }
                if (spawnGroupData == null) {
                    DragonGroupData data = new DragonGroupData(breed, variant);
                    spawnGroupData = data;
                    this.setSpawnGroupId(data.groupId);
                }
            }
        }
        return super.finalizeSpawn(accessor, difficulty, spawnType, spawnGroupData);
    }

    @Generated
    public UUID getSpawnGroupId() {
        return this.spawnGroupId;
    }

    @Generated
    public void setSpawnGroupId(UUID spawnGroupId) {
        this.spawnGroupId = spawnGroupId;
    }

    public static class DragonGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final IDragonBreed breed;
        public final IDragonBreed.Variant variant;
        public UUID groupId;

        public DragonGroupData(IDragonBreed breed, IDragonBreed.Variant variant) {
            super(true);
            this.breed = breed;
            this.variant = variant;
            this.groupId = UUID.randomUUID();
        }
    }
}

