/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.client.particle.particleoptions.DragonBreathParticleOptions;
import dmr.DragonMounts.network.packets.DragonBreathTargetSyncPacket;
import dmr.DragonMounts.server.entity.dragon.DragonAnimationComponent;
import dmr.DragonMounts.types.breath.DragonBreathType;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3d;

abstract class DragonBreathComponent
extends DragonAnimationComponent {
    private static final double breathLength = 2.5;
    private static final double breathRange = 4.0;
    protected Vector3d breathSourcePosition;
    protected PositionTracker breathTarget;
    protected int breathTime = -1;

    protected DragonBreathComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDragonBreath() {
        if (this.breathSourcePosition != null) {
            Vec3 dragonSource = this.position().add(this.breathSourcePosition.x, this.breathSourcePosition.y, this.breathSourcePosition.z);
            Vec3 target = this.getBreathTarget().currentPosition().add(0.0, 0.5, 0.0);
            Vec3 diff = target.subtract(dragonSource).normalize();
            Vec3 breathSource = new Vec3(this.breathSourcePosition.x, this.breathSourcePosition.y, this.breathSourcePosition.z).add(diff.scale(0.5));
            DragonBreathType breathType = this.getDragon().getBreed().getBreathType();
            if (breathType == null) {
                return;
            }
            int particleDensity = breathType.getParticleDensity();
            for (int i = 0; i < particleDensity; ++i) {
                Vec3 speed = new Vec3(diff.x * (double)(0.5f + this.getRandom().nextFloat() / 4.0f), diff.y, diff.z * (double)(0.5f + this.getRandom().nextFloat() / 4.0f));
                DragonBreathParticleOptions breathOptions = new DragonBreathParticleOptions(breathType);
                this.level().addParticle((ParticleOptions)breathOptions, this.getX() + breathSource.x, this.getY() + breathSource.y, this.getZ() + breathSource.z, speed.x, speed.y, speed.z);
            }
        }
    }

    public void setBreathAttackTarget(LivingEntity target) {
        this.setTarget((PositionTracker)new EntityTracker((Entity)target, true));
    }

    private void setTarget(PositionTracker tracker) {
        if (this.isValidTarget(tracker)) {
            this.breathTarget = tracker;
            this.breathTime = -1;
            if (!this.level().isClientSide) {
                if (tracker instanceof EntityTracker) {
                    EntityTracker entityTracker = (EntityTracker)tracker;
                    Entity targetEntity = entityTracker.getEntity();
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)DragonBreathTargetSyncPacket.forEntityTarget(this.getId(), targetEntity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (tracker instanceof BlockPosTracker) {
                    BlockPosTracker blockPosTracker = (BlockPosTracker)tracker;
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)DragonBreathTargetSyncPacket.forPositionTarget(this.getId(), blockPosTracker.currentBlockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    private boolean isValidTarget(PositionTracker tracker) {
        if (tracker == null) {
            return false;
        }
        return tracker.isVisibleBy((LivingEntity)this) || this.level.isClientSide;
    }

    public void setBreathAttackPosition(Vec3 pos) {
        this.setTarget((PositionTracker)new BlockPosTracker(pos));
    }

    public void setBreathAttackBlock(BlockPos pos) {
        this.setTarget((PositionTracker)new BlockPosTracker(pos));
    }

    public void tick() {
        super.tick();
        if (this.hasBreathAttack() && this.hasBreathTarget()) {
            if (this.breathTime == -1) {
                this.breathTime = 50;
                this.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)this.getBreathTarget());
            } else if (this.breathTime == 0) {
                this.stopBreathAttack();
                this.breathTime = -1;
            } else {
                --this.breathTime;
                this.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)this.getBreathTarget());
                this.getDragon().triggerAnim("head-controller", "breath");
                PositionTracker positionTracker = this.getBreathTarget();
                if (positionTracker instanceof EntityTracker) {
                    EntityTracker entityTracker = (EntityTracker)positionTracker;
                    Entity targetEntity = entityTracker.getEntity();
                    if (!targetEntity.isAlive()) {
                        this.stopBreathAttack();
                        return;
                    }
                    this.attackWithBreath((LivingEntity)targetEntity);
                }
                Vec3 dragonPos = this.position();
                Vec3 target = this.getBreathTarget().currentPosition().add(0.0, 0.5, 0.0);
                Vec3 direction = target.subtract(dragonPos).normalize();
                Vec3 breathEnd = dragonPos.add(direction.scale(4.0));
                int breathWidth = 2;
                double minX = Math.min(dragonPos.x, breathEnd.x) - (double)breathWidth;
                double minY = Math.min(dragonPos.y, breathEnd.y) - (double)breathWidth;
                double minZ = Math.min(dragonPos.z, breathEnd.z) - (double)breathWidth;
                double maxX = Math.max(dragonPos.x, breathEnd.x) + (double)breathWidth;
                double maxY = Math.max(dragonPos.y, breathEnd.y) + (double)breathWidth;
                double maxZ = Math.max(dragonPos.z, breathEnd.z) + (double)breathWidth;
                AABB breathBoundingBox = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
                List<LivingEntity> entitiesInRange = this.level.getEntities((Entity)this, breathBoundingBox, ent -> {
                    LivingEntity living;
                    return ent instanceof LivingEntity && this.canHarmWithBreath(living = (LivingEntity)ent);
                }).stream().map(s -> (LivingEntity)s).toList();
                for (LivingEntity entity : entitiesInRange) {
                    EntityTracker entityTracker;
                    PositionTracker positionTracker2 = this.getBreathTarget();
                    if (positionTracker2 instanceof EntityTracker && (entityTracker = (EntityTracker)positionTracker2).getEntity().equals((Object)entity)) continue;
                    this.attackWithBreath(entity);
                }
            }
        }
    }

    public boolean hasBreathAttack() {
        return this.getDragon().getBreed().getBreathType() != null;
    }

    public boolean hasBreathTarget() {
        return this.breathTarget != null;
    }

    public void stopBreathAttack() {
        this.breathTime = 0;
        this.breathTarget = null;
        this.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.getDragon().stopTriggeredAnim("head-controller", "breath");
        if (!this.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)DragonBreathTargetSyncPacket.forStopBreath(this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void attackWithBreath(LivingEntity target) {
        if (!this.canHarmWithBreath(target)) {
            return;
        }
        if (this.getControllingPassenger() != null && this.getControllingPassenger() == target) {
            return;
        }
        DragonBreathType breathType = this.getDragon().getBreed().getBreathType();
        if (breathType == null) {
            return;
        }
        target.hurt(breathType.getDamageSource((LivingEntity)this), breathType.getDamage());
        if (breathType.getFireTime() > 0) {
            target.setRemainingFireTicks(breathType.getFireTime());
        }
        for (DragonBreathType.BreathEffect effect : breathType.getEffects()) {
            ResourceLocation effectResourceLoc;
            Holder.Reference effectType;
            String effectId;
            if (!(this.getRandom().nextFloat() <= effect.getChance()) || (effectId = effect.getEffectId()) == null || (effectType = (Holder.Reference)BuiltInRegistries.MOB_EFFECT.getHolder(effectResourceLoc = ResourceLocation.parse((String)effectId)).orElse(null)) == null) continue;
            MobEffectInstance instance = new MobEffectInstance((Holder)effectType, effect.getDuration(), effect.getAmplifier());
            target.addEffect(instance);
        }
    }

    public boolean canHarmWithBreath(LivingEntity target) {
        return this.getOwner() == null || target != this.getOwner() && this.getOwner().canAttack(target) && !target.isAlliedTo((Entity)this.getOwner());
    }

    @Generated
    public static double getBreathLength() {
        return 2.5;
    }

    @Generated
    public Vector3d getBreathSourcePosition() {
        return this.breathSourcePosition;
    }

    @Generated
    public void setBreathSourcePosition(Vector3d breathSourcePosition) {
        this.breathSourcePosition = breathSourcePosition;
    }

    @Generated
    public PositionTracker getBreathTarget() {
        return this.breathTarget;
    }
}

