/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.server.entity.DragonAgroState;
import dmr.DragonMounts.server.entity.dragon.DragonAttributeComponent;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;

public abstract class AbstractDragonEntity
extends DragonAttributeComponent {
    protected static final EntityDataAccessor<String> uuidDataAccessor = SynchedEntityData.defineId(AbstractDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected DragonAgroState agroState = DragonAgroState.NEUTRAL;

    protected AbstractDragonEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.setDragonUUID(UUID.randomUUID());
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (!this.level.isClientSide) {
            this.getInventory().removeListener((ContainerListener)this);
        }
    }

    public boolean isServer() {
        return !this.level.isClientSide;
    }

    public double getTick(Object o) {
        return this.tickCount;
    }

    public int getAge() {
        return this.age;
    }

    public void ageUp(int p_146741_, boolean p_146742_) {
        super.ageUp(p_146741_, p_146742_);
        this.updateAgeProperties();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("agroState", this.agroState.name());
        if (this.getDragonUUID() != null) {
            compound.putString("dragonUUID", this.getDragonUUID().toString());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("agroState")) {
            this.agroState = DragonAgroState.valueOf(compound.getString("agroState"));
        }
        if (compound.contains("dragonUUID")) {
            this.setDragonUUID(UUID.fromString(compound.getString("dragonUUID")));
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(uuidDataAccessor, (Object)"");
    }

    public UUID getDragonUUID() {
        String id = (String)this.entityData.get(uuidDataAccessor);
        return !id.isBlank() ? UUID.fromString(id) : null;
    }

    public void setDragonUUID(UUID uuid) {
        this.entityData.set(uuidDataAccessor, (Object)uuid.toString());
    }

    @Generated
    public void setAgroState(DragonAgroState agroState) {
        this.agroState = agroState;
    }

    @Generated
    public DragonAgroState getAgroState() {
        return this.agroState;
    }
}

