/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.blockentities;

import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModBlockEntities;
import dmr.DragonMounts.registry.ModComponents;
import dmr.DragonMounts.registry.ModCriterionTriggers;
import dmr.DragonMounts.registry.ModEntities;
import dmr.DragonMounts.server.blocks.DMREggBlock;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.util.PlayerStateUtils;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DMREggBlockEntity
extends BlockEntity {
    private String breedId;
    private String variantId = "";
    private double healthAttribute;
    private double speedAttribute;
    private double damageAttribute;
    private double maxScaleAttribute;
    private int hatchTime = ServerConfig.HATCH_TIME_CONFIG.intValue();
    private String owner;
    private Component customName;
    public int tickCount = 0;

    public DMREggBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.DRAGON_EGG_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public IDragonBreed getBreed() {
        return DragonBreedsRegistry.getDragonBreed(this.getBreedId());
    }

    public void setBreed(IDragonBreed breed) {
        this.setBreedId(breed.getId());
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.saveAdditional(pTag, registries);
        if (this.getBreedId() != null) {
            pTag.putString("breed", this.getBreedId());
        }
        pTag.putInt("hatchTime", this.getHatchTime());
        pTag.putString("owner", this.getOwner() == null ? "" : this.getOwner());
        if (this.getCustomName() != null) {
            pTag.putString("name", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setBreedId(tag.getString("breed"));
        this.setHatchTime(tag.getInt("hatchTime"));
        this.setOwner(tag.getString("owner"));
        String name = tag.getString("name");
        if (!name.isBlank()) {
            this.setCustomName((Component)Component.Serializer.fromJson((String)name, (HolderLookup.Provider)registries));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.setBreedId((String)componentInput.get(ModComponents.DRAGON_BREED));
        this.setHatchTime((Integer)componentInput.getOrDefault(ModComponents.EGG_HATCH_TIME, (Object)ServerConfig.HATCH_TIME_CONFIG.intValue()));
        this.setOwner((String)componentInput.get(ModComponents.EGG_OWNER));
        if (ServerConfig.ENABLE_RANDOM_STATS) {
            this.setSpeedAttribute((Double)componentInput.getOrDefault(ModComponents.DRAGON_MOVEMENT_SPEED_ATTRIBUTE, (Object)Math.random()));
            this.setDamageAttribute((Double)componentInput.getOrDefault(ModComponents.DRAGON_ATTACK_ATTRIBUTE, (Object)Math.random()));
            this.setHealthAttribute((Double)componentInput.getOrDefault(ModComponents.DRAGON_HEALTH_ATTRIBUTE, (Object)Math.random()));
            this.setMaxScaleAttribute((Double)componentInput.getOrDefault(ModComponents.DRAGON_SCALE_ATTRIBUTE, (Object)Math.random()));
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(ModComponents.DRAGON_BREED, (Object)this.getBreedId());
        components.set(ModComponents.EGG_HATCH_TIME, (Object)this.getHatchTime());
        components.set(ModComponents.EGG_OWNER, (Object)this.getOwner());
        if (ServerConfig.ENABLE_RANDOM_STATS) {
            components.set(ModComponents.DRAGON_HEALTH_ATTRIBUTE, (Object)this.getHealthAttribute());
            components.set(ModComponents.DRAGON_ATTACK_ATTRIBUTE, (Object)this.getDamageAttribute());
            components.set(ModComponents.DRAGON_MOVEMENT_SPEED_ATTRIBUTE, (Object)this.getSpeedAttribute());
            components.set(ModComponents.DRAGON_SCALE_ATTRIBUTE, (Object)this.getMaxScaleAttribute());
        }
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        ++this.tickCount;
        int maxHatchTime = this.getBreed() == null ? 1 : this.getBreed().getHatchTime();
        int growthStage = maxHatchTime / 3;
        if (this.tickCount % 20 == 0 && ((Boolean)pState.getValue((Property)DMREggBlock.HATCHING)).booleanValue()) {
            if (this.hatchTime <= 0) {
                if (!pLevel.isClientSide) {
                    this.hatch((ServerLevel)pLevel, pPos);
                }
            } else {
                --this.hatchTime;
                int stage = Mth.clamp((int)((maxHatchTime - this.hatchTime) / growthStage), (int)0, (int)3);
                if (stage == 3) {
                    this.level.playSound(null, pPos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 0.85f, 0.95f + this.level.getRandom().nextFloat() * 0.2f);
                }
            }
        }
    }

    public void hatch(ServerLevel level, BlockPos pos) {
        UUID owner;
        Player player;
        DMREggBlockEntity data = (DMREggBlockEntity)level.getBlockEntity(pos);
        TameableDragonEntity baby = (TameableDragonEntity)ModEntities.DRAGON_ENTITY.get().create((Level)level);
        String ownerId = data.getOwner();
        level.playSound(null, pos, SoundEvents.TURTLE_EGG_HATCH, SoundSource.BLOCKS, 1.2f, 0.95f + level.getRandom().nextFloat() * 0.2f);
        baby.setBreed(data.getBreed());
        baby.setVariant(data.getVariantId());
        baby.setBaby(true);
        baby.setAge(-Math.abs(data.getBreed().getGrowthTime()));
        baby.setPos(pos.getX(), pos.getY(), pos.getZ());
        baby.setHatched(true);
        if (ServerConfig.ENABLE_RANDOM_STATS) {
            baby.setHatchedAttributes(this);
        }
        if (data.getCustomName() != null) {
            baby.setCustomName(data.getCustomName());
        }
        if (!level.addFreshEntity((Entity)baby)) {
            return;
        }
        if (ownerId != null && !ownerId.isBlank() && (player = level.getPlayerByUUID(owner = UUID.fromString(data.getOwner()))) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            DragonOwnerCapability state = PlayerStateUtils.getHandler(player);
            ++state.dragonsHatched;
            ModCriterionTriggers.HATCH_COUNT_TRIGGER.get().trigger(serverPlayer, state.dragonsHatched);
            if (data.getBreed().isHybrid()) {
                ModCriterionTriggers.IS_HYBRID_HATCH_TRIGGER.get().trigger(serverPlayer);
            } else {
                ModCriterionTriggers.HATCH_TRIGGER.get().trigger(serverPlayer, data.getBreedId());
            }
        }
        level.removeBlock(pos, false);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Generated
    public String getBreedId() {
        return this.breedId;
    }

    @Generated
    public void setBreedId(String breedId) {
        this.breedId = breedId;
    }

    @Generated
    public String getVariantId() {
        return this.variantId;
    }

    @Generated
    public void setVariantId(String variantId) {
        this.variantId = variantId;
    }

    @Generated
    public double getHealthAttribute() {
        return this.healthAttribute;
    }

    @Generated
    public void setHealthAttribute(double healthAttribute) {
        this.healthAttribute = healthAttribute;
    }

    @Generated
    public double getSpeedAttribute() {
        return this.speedAttribute;
    }

    @Generated
    public void setSpeedAttribute(double speedAttribute) {
        this.speedAttribute = speedAttribute;
    }

    @Generated
    public double getDamageAttribute() {
        return this.damageAttribute;
    }

    @Generated
    public void setDamageAttribute(double damageAttribute) {
        this.damageAttribute = damageAttribute;
    }

    @Generated
    public double getMaxScaleAttribute() {
        return this.maxScaleAttribute;
    }

    @Generated
    public void setMaxScaleAttribute(double maxScaleAttribute) {
        this.maxScaleAttribute = maxScaleAttribute;
    }

    @Generated
    public int getHatchTime() {
        return this.hatchTime;
    }

    @Generated
    public void setHatchTime(int hatchTime) {
        this.hatchTime = hatchTime;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public Component getCustomName() {
        return this.customName;
    }

    @Generated
    public void setCustomName(Component customName) {
        this.customName = customName;
    }
}

