/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai.behaviours;

import dmr.DragonMounts.registry.ModMemoryModuleTypes;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class ForceSitting
implements BehaviorControl<TameableDragonEntity> {
    private Behavior.Status status = Behavior.Status.STOPPED;

    public Behavior.Status getStatus() {
        return this.status;
    }

    public final boolean tryStart(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        if (entity.isFlying()) {
            this.status = Behavior.Status.RUNNING;
            Vec3 pos = LandRandomPos.getPos((PathfinderMob)entity, (int)8, (int)32);
            if (pos != null) {
                entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos, 0.5f, 0));
            }
            return true;
        }
        if (!entity.isInWater() && !entity.isLeashed() && entity.onGround() && entity.canChangePose()) {
            this.status = Behavior.Status.RUNNING;
            entity.setRandomlySitting(true);
            return true;
        }
        return false;
    }

    public final void tickOrStop(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        if (entity.isFlying()) {
            Vec3 pos;
            if (!entity.getBrain().hasMemoryValue(MemoryModuleType.WALK_TARGET) && (pos = LandRandomPos.getPos((PathfinderMob)entity, (int)8, (int)32)) != null) {
                entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos, 0.5f, 0));
            }
            return;
        }
        entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        entity.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
        entity.getBrain().eraseMemory(ModMemoryModuleTypes.IDLE_TICKS.get());
        if (entity.isInLove() || entity.isInWater() || entity.isLeashed() || entity.hasControllingPassenger()) {
            this.doStop(level, entity, gameTime);
            return;
        }
        if (!entity.getBrain().hasMemoryValue(ModMemoryModuleTypes.SHOULD_SIT.get())) {
            this.doStop(level, entity, gameTime);
        }
    }

    public final void doStop(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        this.status = Behavior.Status.STOPPED;
        entity.setRandomlySitting(false);
    }

    public String debugString() {
        return this.getClass().getSimpleName();
    }
}

