/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai.behaviours;

import com.google.common.collect.ImmutableMap;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Animal;

public class DragonBreedBehaviour
extends Behavior<TameableDragonEntity> {
    private static final int BREEDING_COOLDOWN = 6000;
    private static final int MIN_BREED_TIME = 60;
    private static final int RANDOM_BREED_TIME_ADDITION = 50;
    private final EntityType<TameableDragonEntity> partnerType;
    private final float speedModifier;
    private final int closeEnoughDistance;
    private long spawnChildAtTime;

    public DragonBreedBehaviour(EntityType<TameableDragonEntity> partnerType, float speedModifier, int closeEnoughDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED), 110);
        this.partnerType = partnerType;
        this.speedModifier = speedModifier;
        this.closeEnoughDistance = closeEnoughDistance;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, TameableDragonEntity owner) {
        return owner.isInLove() && this.findValidBreedPartner(owner).isPresent();
    }

    protected void start(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        TameableDragonEntity dragon = this.findValidBreedPartner(entity).get();
        this.setBreedingMemories(entity, dragon);
        BehaviorUtils.lockGazeAndWalkToEachOther((LivingEntity)entity, (LivingEntity)dragon, (float)this.speedModifier, (int)this.closeEnoughDistance);
        int breedTime = 60 + entity.getRandom().nextInt(50);
        this.spawnChildAtTime = gameTime + (long)breedTime;
    }

    protected boolean canStillUse(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        if (!this.hasBreedTargetOfRightType(entity)) {
            return false;
        }
        TameableDragonEntity dragon = this.getBreedTarget(entity);
        return dragon.isAlive() && entity.canMate((Animal)dragon) && BehaviorUtils.entityIsVisible(entity.getBrain(), (LivingEntity)dragon) && gameTime <= this.spawnChildAtTime;
    }

    protected void tick(ServerLevel level, TameableDragonEntity owner, long gameTime) {
        TameableDragonEntity dragon = this.getBreedTarget(owner);
        BehaviorUtils.lockGazeAndWalkToEachOther((LivingEntity)owner, (LivingEntity)dragon, (float)this.speedModifier, (int)this.closeEnoughDistance);
        if (owner.closerThan((Entity)dragon, this.closeEnoughDistance) && gameTime >= this.spawnChildAtTime) {
            this.completeBreeding(level, owner, dragon);
        }
    }

    protected void stop(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        this.clearBreedingMemories(entity);
        this.spawnChildAtTime = 0L;
    }

    private TameableDragonEntity getBreedTarget(TameableDragonEntity dragon) {
        return (TameableDragonEntity)((Object)dragon.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get());
    }

    private boolean hasBreedTargetOfRightType(TameableDragonEntity dragon) {
        Brain<TameableDragonEntity> brain = dragon.getBrain();
        return brain.hasMemoryValue(MemoryModuleType.BREED_TARGET) && brain.getMemory(MemoryModuleType.BREED_TARGET).isPresent() && ((AgeableMob)brain.getMemory(MemoryModuleType.BREED_TARGET).get()).getType() == this.partnerType;
    }

    private Optional<TameableDragonEntity> findValidBreedPartner(TameableDragonEntity dragon) {
        NearestVisibleLivingEntities entities = (NearestVisibleLivingEntities)dragon.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get();
        return entities.findClosest(livingEntity -> {
            TameableDragonEntity partner;
            return livingEntity instanceof TameableDragonEntity && dragon.canMate((Animal)(partner = (TameableDragonEntity)((Object)livingEntity)));
        }).map(TameableDragonEntity.class::cast);
    }

    private void setBreedingMemories(TameableDragonEntity dragon1, TameableDragonEntity dragon2) {
        dragon1.getBrain().setMemory(MemoryModuleType.BREED_TARGET, (Object)dragon2);
        dragon2.getBrain().setMemory(MemoryModuleType.BREED_TARGET, (Object)dragon1);
    }

    private void completeBreeding(ServerLevel level, TameableDragonEntity parent1, TameableDragonEntity parent2) {
        parent1.spawnChildFromBreeding(level, (Animal)parent2);
        this.clearBreedingMemories(parent1);
        this.clearBreedingMemories(parent2);
        parent1.setAge(6000);
        parent2.setAge(6000);
        parent1.resetLove();
        parent2.resetLove();
    }

    private void clearBreedingMemories(TameableDragonEntity dragon) {
        Brain<TameableDragonEntity> brain = dragon.getBrain();
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
    }
}

