/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai.behaviours;

import dmr.DragonMounts.registry.ModMemoryModuleTypes;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;

public class ChangeIdleTimer
implements BehaviorControl<TameableDragonEntity> {
    private static final int MAX_IDLE_TIME = 1000;
    private Behavior.Status status = Behavior.Status.STOPPED;
    private final ChangeType changeType;
    private final int amount;

    public ChangeIdleTimer(ChangeType changeType, int amount) {
        this.changeType = changeType;
        this.amount = amount;
    }

    public Behavior.Status getStatus() {
        return this.status;
    }

    public final boolean tryStart(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        this.status = Behavior.Status.RUNNING;
        return true;
    }

    public final void tickOrStop(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        int idleTime = this.getCurrentIdleTime(entity);
        int newIdleTime = this.calculateNewIdleTime(idleTime);
        entity.getBrain().setMemory(ModMemoryModuleTypes.IDLE_TICKS.get(), (Object)Math.max(0, Math.min(newIdleTime, 1000)));
        this.doStop(level, entity, gameTime);
    }

    public final void doStop(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        this.status = Behavior.Status.STOPPED;
    }

    public String debugString() {
        return this.getClass().getSimpleName();
    }

    private int getCurrentIdleTime(TameableDragonEntity entity) {
        return entity.getBrain().getMemory(ModMemoryModuleTypes.IDLE_TICKS.get()).orElse(0);
    }

    private int calculateNewIdleTime(int currentIdleTime) {
        return switch (this.changeType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> currentIdleTime + this.amount;
            case 1 -> currentIdleTime - this.amount;
            case 2 -> this.amount;
        };
    }

    public static enum ChangeType {
        INCREASE,
        DECREASE,
        SET;

    }
}

