/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.network.NetworkHandler;
import dmr.DragonMounts.server.inventory.DragonInventoryHandler;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RequestDragonInventoryPacket
extends AbstractMessage<RequestDragonInventoryPacket> {
    private static final StreamCodec<FriendlyByteBuf, RequestDragonInventoryPacket> STREAM_CODEC = StreamCodec.composite(NetworkHandler.UUID_CODEC, RequestDragonInventoryPacket::getId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, RequestDragonInventoryPacket::getTag, RequestDragonInventoryPacket::new);
    private final UUID id;
    private final CompoundTag tag;

    RequestDragonInventoryPacket() {
        this.id = new UUID(0L, 0L);
        this.tag = new CompoundTag();
    }

    public RequestDragonInventoryPacket(UUID id, CompoundTag tag) {
        this.id = id;
        this.tag = tag;
    }

    @Override
    protected String getTypeName() {
        return "request_dragon_inventory";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, RequestDragonInventoryPacket> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void handle(IPayloadContext context, Player player) {
    }

    @Override
    public void handleServer(IPayloadContext context, ServerPlayer player) {
    }

    @Override
    public void handleClient(IPayloadContext context, Player player) {
        if (player.level().isClientSide()) {
            CompoundTag tag = this.tag;
            DragonInventoryHandler.DragonInventory inventory = new DragonInventoryHandler.DragonInventory(player.level());
            inventory.readNBT(tag);
            DragonInventoryHandler.clientSideInventories.put(this.id, inventory);
        }
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public CompoundTag getTag() {
        return this.tag;
    }
}

