/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.common.handlers.DragonWhistleHandler;
import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.server.entity.DragonAgroState;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.server.items.DragonWhistleItem;
import dmr.DragonMounts.util.PlayerStateUtils;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DragonCommandPacket
extends AbstractMessage<DragonCommandPacket> {
    private static final StreamCodec<FriendlyByteBuf, DragonCommandPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DragonCommandPacket::getCommand, DragonCommandPacket::new);
    private final int command;

    DragonCommandPacket() {
        this.command = -1;
    }

    public DragonCommandPacket(int command) {
        this.command = command;
    }

    public DragonCommandPacket(Command command) {
        this(command.id);
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, DragonCommandPacket> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    protected String getTypeName() {
        return "dragon_command";
    }

    @Override
    public void handle(IPayloadContext context, Player player) {
    }

    @Override
    public void handleServer(IPayloadContext context, ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.level;
        DragonWhistleItem whistleItem = DragonWhistleHandler.getDragonWhistleItem((Player)player);
        if (whistleItem == null) {
            return;
        }
        int index = whistleItem.getColor().getId();
        DragonOwnerCapability state = PlayerStateUtils.getHandler((Player)player);
        DragonWhistleHandler.DragonInstance instance = state.dragonInstances.get(index);
        if (instance == null) {
            return;
        }
        Command cmd = Command.values()[this.command];
        if (cmd == Command.WHISTLE) {
            DragonWhistleHandler.summonDragon((Player)player);
            player.displayClientMessage((Component)Component.translatable((String)"dmr.command_mode.whistle.text"), true);
            return;
        }
        Entity dragonEntity = level.getEntity(instance.getEntityId());
        if (dragonEntity instanceof TameableDragonEntity) {
            TameableDragonEntity dragon = (TameableDragonEntity)dragonEntity;
            switch (cmd.ordinal()) {
                case 0: {
                    dragon.setWanderTarget(Optional.empty());
                    dragon.setOrderedToSit(true);
                    player.displayClientMessage((Component)Component.translatable((String)"dmr.command_mode.sit.text"), true);
                    break;
                }
                case 1: {
                    dragon.setOrderedToSit(false);
                    dragon.setWanderTarget(Optional.empty());
                    player.displayClientMessage((Component)Component.translatable((String)"dmr.command_mode.follow.text"), true);
                    break;
                }
                case 2: {
                    dragon.setOrderedToSit(false);
                    dragon.setWanderTarget((Optional)Optional.of(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)player.blockPosition())));
                    player.displayClientMessage((Component)Component.translatable((String)"dmr.command_mode.wander.text"), true);
                    break;
                }
                case 4: {
                    dragon.setAgroState(DragonAgroState.PASSIVE);
                    player.displayClientMessage((Component)Component.translatable((String)"dmr.command_mode.passive.text"), true);
                    break;
                }
                case 5: {
                    dragon.setAgroState(DragonAgroState.NEUTRAL);
                    player.displayClientMessage((Component)Component.translatable((String)"dmr.command_mode.neutral.text"), true);
                    break;
                }
                case 6: {
                    dragon.setAgroState(DragonAgroState.AGGRESSIVE);
                    player.displayClientMessage((Component)Component.translatable((String)"dmr.command_mode.aggressive.text"), true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)Command.values()[this.command]));
                }
            }
        }
    }

    @Generated
    public int getCommand() {
        return this.command;
    }

    public static enum Command {
        SIT(0),
        FOLLOW(1),
        WANDER(2),
        WHISTLE(3),
        PASSIVE(4),
        NEUTRAL(5),
        AGGRESSIVE(6);

        public final int id;

        private Command(int id) {
            this.id = id;
        }
    }
}

