/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.network.PacketHelper;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DragonBreathTargetSyncPacket
extends AbstractMessage<DragonBreathTargetSyncPacket> {
    private static final StreamCodec<FriendlyByteBuf, DragonBreathTargetSyncPacket> STREAM_CODEC = PacketHelper.createCodec(DragonBreathTargetSyncPacket::encode, DragonBreathTargetSyncPacket::decode);
    private final int dragonId;
    private final byte targetType;
    private final int entityId;
    private final BlockPos pos;

    public static void encode(FriendlyByteBuf buffer, DragonBreathTargetSyncPacket packet) {
        buffer.writeInt(packet.dragonId);
        buffer.writeByte(packet.targetType);
        if (packet.targetType == 1) {
            buffer.writeInt(packet.entityId);
        } else if (packet.targetType == 2) {
            buffer.writeBlockPos(packet.pos);
        }
    }

    public static DragonBreathTargetSyncPacket decode(FriendlyByteBuf buffer) {
        int dragonId = buffer.readInt();
        byte targetType = buffer.readByte();
        int entityId = -1;
        BlockPos pos = BlockPos.ZERO;
        if (targetType == 1) {
            entityId = buffer.readInt();
        } else if (targetType == 2) {
            pos = buffer.readBlockPos();
        }
        return new DragonBreathTargetSyncPacket(dragonId, targetType, entityId, pos);
    }

    DragonBreathTargetSyncPacket() {
        this.dragonId = -1;
        this.targetType = 0;
        this.entityId = -1;
        this.pos = BlockPos.ZERO;
    }

    public DragonBreathTargetSyncPacket(int dragonId, byte targetType, int entityId, BlockPos pos) {
        this.dragonId = dragonId;
        this.targetType = targetType;
        this.entityId = entityId;
        this.pos = pos;
    }

    @Override
    protected String getTypeName() {
        return "dragon_breath_target_sync";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, DragonBreathTargetSyncPacket> streamCodec() {
        return STREAM_CODEC;
    }

    public static DragonBreathTargetSyncPacket forEntityTarget(int dragonId, int entityId) {
        return new DragonBreathTargetSyncPacket(dragonId, 1, entityId, BlockPos.ZERO);
    }

    public static DragonBreathTargetSyncPacket forPositionTarget(int dragonId, BlockPos pos) {
        return new DragonBreathTargetSyncPacket(dragonId, 2, -1, pos);
    }

    public static DragonBreathTargetSyncPacket forStopBreath(int dragonId) {
        return new DragonBreathTargetSyncPacket(dragonId, 0, -1, BlockPos.ZERO);
    }

    @Override
    public void handle(IPayloadContext context, Player player) {
        Level level = player.level;
        Entity entity = level.getEntity(this.dragonId);
        if (entity instanceof TameableDragonEntity) {
            TameableDragonEntity dragon = (TameableDragonEntity)entity;
            if (this.targetType == 0) {
                dragon.stopBreathAttack();
            } else if (this.targetType == 1) {
                Entity targetEntity = level.getEntity(this.entityId);
                if (targetEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)targetEntity;
                    dragon.setBreathAttackTarget(livingEntity);
                }
            } else if (this.targetType == 2) {
                dragon.setBreathAttackBlock(this.pos);
            }
        }
    }

    @Generated
    public int getDragonId() {
        return this.dragonId;
    }

    @Generated
    public byte getTargetType() {
        return this.targetType;
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Generated
    public BlockPos getPos() {
        return this.pos;
    }
}

