/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.config;

import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.config.annotations.Config;
import dmr.DragonMounts.config.annotations.RangeConstraint;
import dmr.DragonMounts.config.annotations.SyncedConfig;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigProcessor {
    private static final Map<String, ConfigField> SYNCED_CONFIGS = new HashMap<String, ConfigField>();
    private static final Map<String, ModConfigSpec.ConfigValue<?>> CONFIG_VALUES = new HashMap();

    public static ModConfigSpec processConfig(Class<?> configClass) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        for (Field field : configClass.getDeclaredFields()) {
            Config configAnnotation = field.getAnnotation(Config.class);
            if (configAnnotation == null) continue;
            String[] categories = configAnnotation.category();
            ModConfigSpec.Builder targetBuilder = builder;
            for (String category : categories) {
                builder = builder.push(category);
            }
            ConfigProcessor.processField(field, configAnnotation, targetBuilder, configClass);
            for (String ignored : categories) {
                builder = builder.pop();
            }
        }
        return builder.build();
    }

    private static void processField(Field field, Config configAnnotation, ModConfigSpec.Builder builder, Class<?> configClass) {
        RangeConstraint rangeAnnotation;
        String key = configAnnotation.key();
        String[] comment = configAnnotation.comment();
        Object translation = configAnnotation.translation();
        boolean worldRestart = configAnnotation.worldRestart();
        if (comment.length > 0) {
            builder.comment(comment);
        }
        if (((String)translation).isEmpty()) {
            String configType = configClass == ServerConfig.class ? "server" : "client";
            translation = "dmr.config." + configType + "." + key;
        }
        builder.translation((String)translation);
        if (worldRestart) {
            builder.worldRestart();
        }
        double min = (rangeAnnotation = field.getAnnotation(RangeConstraint.class)) != null ? rangeAnnotation.min() : Double.MIN_VALUE;
        double max = rangeAnnotation != null ? rangeAnnotation.max() : Double.MAX_VALUE;
        try {
            ModConfigSpec.BooleanValue configValue;
            field.setAccessible(true);
            Object defaultValue = field.get(null);
            Class<?> fieldType = field.getType();
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                configValue = builder.define(key, (Boolean)defaultValue == true);
            } else if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                configValue = builder.defineInRange(key, ((Integer)defaultValue).intValue(), (int)min, (int)max);
            } else if (fieldType == Long.TYPE || fieldType == Long.class) {
                configValue = builder.defineInRange(key, ((Long)defaultValue).longValue(), (long)min, (long)max);
            } else if (fieldType == Double.TYPE || fieldType == Double.class) {
                configValue = builder.defineInRange(key, ((Double)defaultValue).doubleValue(), min, max);
            } else if (fieldType == String.class) {
                configValue = builder.define(key, (Object)((String)defaultValue));
            } else {
                throw new IllegalArgumentException("Unsupported config field type: " + fieldType.getName());
            }
            CONFIG_VALUES.put(key, (ModConfigSpec.ConfigValue<?>)configValue);
            boolean isServerConfig = configClass == ServerConfig.class;
            SyncedConfig syncedAnnotation = field.getAnnotation(SyncedConfig.class);
            if (isServerConfig || syncedAnnotation != null) {
                SYNCED_CONFIGS.put(key, new ConfigField(field, configClass, syncedAnnotation, isServerConfig));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to process config field: " + field.getName(), e);
        }
    }

    public static void updateFieldValues(Class<?> configClass) {
        for (Field field : configClass.getDeclaredFields()) {
            String key;
            ModConfigSpec.ConfigValue<?> configValue;
            Config configAnnotation = field.getAnnotation(Config.class);
            if (configAnnotation == null || (configValue = CONFIG_VALUES.get(key = configAnnotation.key())) == null) continue;
            try {
                field.setAccessible(true);
                Object value = configValue.get();
                field.set(null, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to update config field: " + field.getName(), e);
            }
        }
    }

    public static Map<String, ConfigField> getSyncedConfigs() {
        return SYNCED_CONFIGS;
    }

    public static ModConfigSpec.ConfigValue<?> getConfigValue(String key) {
        return CONFIG_VALUES.get(key);
    }

    public record ConfigField(Field field, Class<?> configClass, SyncedConfig syncConfig, boolean isServerConfig) {
        public boolean shouldSyncToClient() {
            return this.isServerConfig;
        }

        public boolean shouldSyncToServer() {
            return !this.isServerConfig && this.syncConfig != null;
        }

        public Object getValue() {
            try {
                this.field.setAccessible(true);
                return this.field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get config value: " + this.field.getName(), e);
            }
        }

        public void setValue(Object value) {
            try {
                this.field.setAccessible(true);
                this.field.set(null, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to set config value: " + this.field.getName(), e);
            }
        }
    }
}

