/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.common.handlers;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.common.capability.types.NBTInterface;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.network.packets.CompleteDataSync;
import dmr.DragonMounts.network.packets.DragonStatePacket;
import dmr.DragonMounts.registry.ModCapabilities;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.registry.ModSounds;
import dmr.DragonMounts.server.entity.DragonConstants;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.server.items.DragonWhistleItem;
import dmr.DragonMounts.server.worlddata.DragonWorldData;
import dmr.DragonMounts.server.worlddata.DragonWorldDataManager;
import dmr.DragonMounts.util.PlayerStateUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.gametest.GameTestHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public class DragonWhistleHandler {
    public static DragonWhistleItem getDragonWhistleItem(Player player) {
        DragonWhistleItem whistleItem2;
        Item item;
        int i;
        DragonWhistleItem whistleItem3;
        DragonOwnerCapability state = PlayerStateUtils.getHandler(player);
        Function<DragonWhistleItem, Boolean> isValid = whistleItem -> {
            if (whistleItem.getColor() == null) {
                return false;
            }
            return state.dragonNBTs.containsKey(whistleItem.getColor().getId());
        };
        Item item2 = player.getInventory().getSelected().getItem();
        if (item2 instanceof DragonWhistleItem && isValid.apply(whistleItem3 = (DragonWhistleItem)item2).booleanValue()) {
            return whistleItem3;
        }
        item2 = ((ItemStack)player.getInventory().offhand.getFirst()).getItem();
        if (item2 instanceof DragonWhistleItem && isValid.apply(whistleItem3 = (DragonWhistleItem)item2).booleanValue()) {
            return whistleItem3;
        }
        for (i = 0; i < 9; ++i) {
            item = player.getInventory().getItem(i).getItem();
            if (!(item instanceof DragonWhistleItem) || !isValid.apply(whistleItem2 = (DragonWhistleItem)item).booleanValue()) continue;
            return whistleItem2;
        }
        for (i = 9; i < player.getInventory().getContainerSize(); ++i) {
            item = player.getInventory().getItem(i).getItem();
            if (!(item instanceof DragonWhistleItem) || !isValid.apply(whistleItem2 = (DragonWhistleItem)item).booleanValue()) continue;
            return whistleItem2;
        }
        return null;
    }

    public static int getDragonSummonIndex(Player player) {
        DragonWhistleItem whistleItem = DragonWhistleHandler.getDragonWhistleItem(player);
        return whistleItem != null ? whistleItem.getColor().getId() : -1;
    }

    public static int getDragonSummonIndex(Player player, UUID dragonUUID) {
        DragonOwnerCapability handler = PlayerStateUtils.getHandler(player);
        return handler.dragonInstances.entrySet().stream().filter(entry -> entry.getValue() != null && ((DragonInstance)entry.getValue()).UUID.equals(dragonUUID)).map(Map.Entry::getKey).findFirst().orElse(0);
    }

    public static void setDragon(Player player, TameableDragonEntity dragon, int index) {
        ((DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY)).setPlayerInstance(player);
        ((DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY)).setDragonToWhistle(dragon, index);
    }

    public static boolean canCall(Player player, int index) {
        DragonOwnerCapability handler = PlayerStateUtils.getHandler(player);
        if (index == -1) {
            player.displayClientMessage((Component)Component.translatable((String)"dmr.dragon_call.no_whistle").withStyle(ChatFormatting.RED), true);
            return false;
        }
        if (!player.level.isClientSide && (handler.dragonNBTs.containsKey(index) && handler.dragonNBTs.get(index) == null || handler.dragonInstances.containsKey(index) && handler.dragonInstances.get(index) == null || handler.dragonInstances.containsKey(index) != handler.dragonNBTs.containsKey(index))) {
            handler.dragonNBTs.remove(index);
            handler.dragonInstances.remove(index);
            handler.respawnDelays.remove(index);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new CompleteDataSync(player), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return false;
        }
        if (!handler.dragonInstances.containsKey(index) || handler.dragonInstances.get(index) == null) {
            if (!player.level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"dmr.dragon_call.nodragon").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        if (handler.respawnDelays.getOrDefault(index, 0) > 0) {
            if (!player.level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"dmr.dragon_call.respawn", (Object[])new Object[]{handler.respawnDelays.getOrDefault(index, 0) / 20}).withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        if (player.getVehicle() != null) {
            if (!player.level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"dmr.dragon_call.riding").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        if (ServerConfig.CALL_CHECK_SPACE && !GameTestHooks.isGametestEnabled() && !player.level.noBlockCollision(null, player.getBoundingBox().move(0.0, 1.0, 0.0).inflate(1.0, 1.0, 1.0))) {
            if (!player.level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"dmr.dragon_call.nospace").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        if (handler.lastCall != null && ServerConfig.WHISTLE_COOLDOWN_CONFIG > 0L && handler.lastCall + ServerConfig.WHISTLE_COOLDOWN_CONFIG > System.currentTimeMillis()) {
            if (!player.level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"dmr.dragon_call.on_cooldown").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        return true;
    }

    public static void summonDragon(Player player) {
        if (player != null && DragonWhistleHandler.callDragon(player)) {
            DragonOwnerCapability handler = PlayerStateUtils.getHandler(player);
            handler.lastCall = System.currentTimeMillis();
            ModItems.DRAGON_WHISTLES.values().forEach(s -> {
                if (!player.getCooldowns().isOnCooldown((Item)s.get())) {
                    player.getCooldowns().addCooldown((Item)s.get(), (int)TimeUnit.SECONDS.convert(ServerConfig.WHISTLE_COOLDOWN_CONFIG, TimeUnit.MILLISECONDS) * 20);
                }
            });
        }
    }

    public static boolean callDragon(Player player) {
        if (player != null) {
            ResourceKey key;
            DragonOwnerCapability cap = (DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY);
            int summonItemIndex = DragonWhistleHandler.getDragonSummonIndex(player);
            if (!DragonWhistleHandler.canCall(player, summonItemIndex)) {
                return false;
            }
            Random rand = new Random();
            player.level.playSound(null, player.blockPosition(), ModSounds.DRAGON_WHISTLE_SOUND.get(), player.getSoundSource(), 0.75f, (float)((double)1.4f + rand.nextGaussian() / 3.0));
            if (player.level.isClientSide) {
                return true;
            }
            DragonInstance instance = cap.dragonInstances.get(summonItemIndex);
            TameableDragonEntity dragon = DragonWhistleHandler.findDragon(player, summonItemIndex);
            if (instance != null && (key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)instance.getDimension()))) != player.level.dimension()) {
                MinecraftServer server = player.level.getServer();
                assert (server != null);
                ServerLevel level = server.getLevel(key);
                DragonWorldData worldData1 = DragonWorldDataManager.getInstance((Level)level);
                DragonWorldData worldData2 = DragonWorldDataManager.getInstance(player.level);
                worldData2.dragonInventories.put(instance.getUUID(), worldData1.dragonInventories.get(instance.getUUID()));
                worldData1.dragonInventories.remove(instance.getUUID());
                DMR.LOGGER.debug("Transferring dragon inventory from {} to {}", (Object)instance.getDimension(), (Object)player.level.dimension().location());
            }
            if (dragon != null) {
                dragon.setHealth(Math.max(1.0f, dragon.getHealth()));
                dragon.ejectPassengers();
                if (dragon.position().distanceTo(player.position()) <= DragonConstants.BASE_FOLLOW_RANGE * 2.0) {
                    dragon.setOrderedToSit(false);
                    dragon.setWanderTarget(Optional.empty());
                    cap.lastSummons.put(summonItemIndex, dragon.getUUID());
                    DMR.LOGGER.debug("Making dragon: {} follow player: {}", (Object)dragon.getDragonUUID(), (Object)player.getName().getString());
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)dragon, (CustomPacketPayload)new DragonStatePacket(dragon.getId(), 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    dragon.setOrderedToSit(false);
                    dragon.setWanderTarget(Optional.empty());
                    cap.lastSummons.put(summonItemIndex, dragon.getUUID());
                    DMR.LOGGER.debug("Teleporting dragon: {} to player: {}", (Object)dragon.getDragonUUID(), (Object)player.getName().getString());
                    dragon.setPos(player.getX(), player.getY(), player.getZ());
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)dragon, (CustomPacketPayload)new DragonStatePacket(dragon.getId(), 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                return true;
            }
            TameableDragonEntity newDragon = cap.createDragonEntity(player, player.level, summonItemIndex);
            if (newDragon == null) {
                return false;
            }
            DMR.LOGGER.debug("Spawning new dragon: {} for player: {}", (Object)newDragon.getDragonUUID(), (Object)player.getName().getString());
            newDragon.setPos(player.getX(), player.getY(), player.getZ());
            player.level.addFreshEntity((Entity)newDragon);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)newDragon, (CustomPacketPayload)new DragonStatePacket(newDragon.getId(), 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return false;
    }

    public static TameableDragonEntity findDragon(Player player, int index) {
        if (player.level.isClientSide) {
            return null;
        }
        DragonOwnerCapability cap = (DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY);
        DragonInstance instance = cap.dragonInstances.get(index);
        if (instance != null) {
            Entity entity;
            ServerLevel level;
            String dim = instance.getDimension();
            MinecraftServer server = player.level.getServer();
            assert (server != null);
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dim));
            if (key == player.level.dimension() && (level = server.getLevel(key)) != null && (entity = level.getEntity(instance.getEntityId())) instanceof TameableDragonEntity) {
                TameableDragonEntity dragon = (TameableDragonEntity)entity;
                DMR.LOGGER.debug("Found dragon: {} from entity id: {}", (Object)dragon, (Object)instance.getEntityId());
                return dragon;
            }
            DMR.LOGGER.debug("Searching for dragon: {} near player: {}", (Object)instance.getUUID(), (Object)player.getName().getString());
            List entities = player.level.getNearbyEntities(TameableDragonEntity.class, TargetingConditions.forNonCombat(), (LivingEntity)player, AABB.ofSize((Vec3)player.position(), (double)100.0, (double)100.0, (double)100.0));
            for (TameableDragonEntity entity2 : entities) {
                if (entity2.getDragonUUID() == null || !entity2.getDragonUUID().equals(instance.getUUID())) continue;
                DMR.LOGGER.debug("Found dragon: {} near player: {}", (Object)entity2, (Object)player.getName().getString());
                return entity2;
            }
        }
        DMR.LOGGER.debug("Could not find dragon: {} for player: {}", (Object)instance.getUUID(), (Object)player.getName().getString());
        return null;
    }

    public static class DragonInstance
    implements NBTInterface {
        String dimension;
        UUID entityId;
        UUID UUID;

        public DragonInstance(Level level, UUID entityId, UUID dragonUUID) {
            this.dimension = level.dimension().location().toString();
            this.entityId = entityId;
            this.UUID = dragonUUID;
        }

        public DragonInstance(TameableDragonEntity dragon) {
            this.dimension = dragon.level.dimension().location().toString();
            this.entityId = dragon.getUUID();
            this.UUID = dragon.getDragonUUID();
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.putString("dimension", this.dimension);
            tag.putUUID("entityId", this.entityId);
            tag.putUUID("uuid", this.UUID);
            return tag;
        }

        @Override
        public void readNBT(CompoundTag base) {
            if (base.contains("dimension")) {
                this.dimension = base.getString("dimension");
            }
            if (base.contains("entityId")) {
                this.entityId = base.getUUID("entityId");
            }
            if (base.contains("uuid")) {
                this.UUID = base.getUUID("uuid");
            }
        }

        @Generated
        public String getDimension() {
            return this.dimension;
        }

        @Generated
        public UUID getEntityId() {
            return this.entityId;
        }

        @Generated
        public UUID getUUID() {
            return this.UUID;
        }

        @Generated
        public DragonInstance(String dimension, UUID entityId, UUID UUID2) {
            this.dimension = dimension;
            this.entityId = entityId;
            this.UUID = UUID2;
        }

        @Generated
        public DragonInstance() {
        }
    }
}

