/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.client.gui.CommandMenu.CommandMenuScreen;
import dmr.DragonMounts.client.handlers.CommandOverlayHandler;
import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.common.handlers.DragonWhistleHandler;
import dmr.DragonMounts.config.ClientConfig;
import dmr.DragonMounts.network.packets.DismountDragonPacket;
import dmr.DragonMounts.network.packets.SummonDragonPacket;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.server.items.DragonWhistleItem;
import dmr.DragonMounts.util.PlayerStateUtils;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.network.PacketDistributor;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="dmr", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class KeyInputHandler {
    public static KeyMapping SUMMON_DRAGON = new KeyMapping("dmr.keybind.summon_dragon", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "dmr.keybind.category");
    public static KeyMapping ATTACK_KEY = new KeyMapping("dmr.keybind.attack", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 342, "dmr.keybind.category");
    public static KeyMapping DRAGON_COMMAND_KEY = new KeyMapping("dmr.keybind.dragon_command", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "dmr.keybind.category");
    public static KeyMapping DISMOUNT_KEY = new KeyMapping("dmr.keybind.dismount", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "dmr.keybind.category");
    public static KeyMapping DESCEND_KEY = new KeyMapping("dmr.keybind.descend", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "dmr.keybind.category");
    private static boolean lastWheelState = false;

    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register(SUMMON_DRAGON);
        event.register(ATTACK_KEY);
        event.register(DRAGON_COMMAND_KEY);
        event.register(DISMOUNT_KEY);
        event.register(DESCEND_KEY);
    }

    public static void onKeyboardTick() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        if (mc.player == null) {
            return;
        }
        DragonWhistleItem whistleItem = DragonWhistleHandler.getDragonWhistleItem((Player)mc.player);
        if (whistleItem == null) {
            return;
        }
        DragonOwnerCapability capability = PlayerStateUtils.getHandler((Player)mc.player);
        if (!capability.dragonNBTs.containsKey(whistleItem.getColor().getId())) {
            return;
        }
        long handle = Minecraft.getInstance().getWindow().getWindow();
        int keycode = DRAGON_COMMAND_KEY.getKey().getValue();
        if (keycode >= 0) {
            boolean radialMenuKeyDown;
            boolean bl = DRAGON_COMMAND_KEY.matchesMouse(keycode) ? GLFW.glfwGetMouseButton((long)handle, (int)keycode) == 1 : (radialMenuKeyDown = InputConstants.isKeyDown((long)handle, (int)keycode));
            if (radialMenuKeyDown != lastWheelState && radialMenuKeyDown != CommandMenuScreen.active && radialMenuKeyDown && (mc.screen == null || mc.screen instanceof CommandMenuScreen)) {
                CommandOverlayHandler.resetTimer();
                CommandMenuScreen.activate();
                DMR.LOGGER.debug("Command Menu activated");
            }
            lastWheelState = radialMenuKeyDown;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @EventBusSubscriber(modid="dmr", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    public static class KeyClickHandler {
        private static Long lastUnshift = null;
        private static boolean wasShiftDown = false;

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void clientTick(ClientTickEvent.Pre event) {
            KeyInputHandler.onKeyboardTick();
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void clientTick(ClientTickEvent.Post event) {
            if (Minecraft.getInstance().level == null) {
                return;
            }
            if (Minecraft.getInstance().player == null) {
                return;
            }
            if (Minecraft.getInstance().screen != null) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            if (player.getControlledVehicle() instanceof TameableDragonEntity) {
                if (Minecraft.getInstance().options.keyShift.consumeClick()) {
                    wasShiftDown = true;
                    if (ClientConfig.DOUBLE_PRESS_DISMOUNT) {
                        if (lastUnshift != null && System.currentTimeMillis() > lastUnshift && System.currentTimeMillis() < lastUnshift + TimeUnit.MILLISECONDS.convert(2L, TimeUnit.SECONDS)) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new DismountDragonPacket(player.getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            lastUnshift = null;
                            wasShiftDown = false;
                        }
                    } else {
                        PacketDistributor.sendToServer((CustomPacketPayload)new DismountDragonPacket(player.getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    return;
                }
                if (wasShiftDown && !Minecraft.getInstance().options.keyShift.isDown()) {
                    lastUnshift = System.currentTimeMillis();
                    wasShiftDown = false;
                }
                if (DISMOUNT_KEY.consumeClick()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new DismountDragonPacket(player.getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return;
                }
            } else if (SUMMON_DRAGON.consumeClick()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SummonDragonPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
        }
    }
}

