/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay.render;

import at.ridgo8.moreoverlays.api.lightoverlay.ILightRenderer;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class CrossOverlayRenderer
implements ILightRenderer {
    private static final ResourceLocation BLANK_TEX = ResourceLocation.fromNamespaceAndPath((String)"moreoverlays", (String)"textures/blank.png");
    private static Tesselator tess = Tesselator.getInstance();
    private static BufferBuilder renderer = tess.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
    private static Minecraft minecraft = Minecraft.getInstance();

    private static void drawVertex(Matrix4f matrix, double x, double y, double z, float r, float g, float b) {
        float xf = (float)x;
        float yf = (float)y;
        float zf = (float)z;
        float tx = matrix.m00() * xf + matrix.m10() * yf + matrix.m20() * zf + matrix.m30();
        float ty = matrix.m01() * xf + matrix.m11() * yf + matrix.m21() * zf + matrix.m31();
        float tz = matrix.m02() * xf + matrix.m12() * yf + matrix.m22() * zf + matrix.m32();
        renderer.addVertex(tx, ty, tz).setColor(r, g, b, 1.0f);
    }

    private static double computeWorldWidthFromPixels(double desiredPixelWidth, double distanceToCamera) {
        double fovDegrees;
        if (desiredPixelWidth <= 0.0) {
            return 0.0;
        }
        int screenHeight = Math.max(1, Minecraft.getInstance().getWindow().getHeight());
        try {
            Object fovObj = Minecraft.getInstance().options.fov().get();
            fovDegrees = fovObj instanceof Integer ? ((Integer)fovObj).doubleValue() : (fovObj instanceof Double ? (Double)fovObj : 70.0);
        }
        catch (Throwable t) {
            fovDegrees = 70.0;
        }
        double fovRadians = Math.toRadians(fovDegrees);
        double pixelsToWorldFactor = 2.0 * Math.tan(fovRadians / 2.0) / (double)screenHeight;
        double widthWorld = desiredPixelWidth * Math.max(0.0, distanceToCamera) * pixelsToWorldFactor;
        return Math.max(widthWorld, 0.01);
    }

    private static void addThickLine(Matrix4f currentMatrix, Vector3f cameraLook, double cameraX, double cameraY, double cameraZ, double ax, double ay, double az, double bx, double by, double bz, float r, float g, float b, double desiredPixelWidth) {
        float ux;
        float uy;
        float uz;
        double mx = (ax + bx) * 0.5;
        double my = (ay + by) * 0.5;
        double mz = (az + bz) * 0.5;
        double dx = mx - cameraX;
        double dy = my - cameraY;
        double dz = mz - cameraZ;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double worldWidth = CrossOverlayRenderer.computeWorldWidthFromPixels(desiredPixelWidth, distance);
        float half = (float)(worldWidth * 0.5);
        float vy = (float)(by - ay);
        float vz = (float)(bz - az);
        float px = vy * cameraLook.z - vz * cameraLook.y;
        float vx = (float)(bx - ax);
        float py = vz * cameraLook.x - vx * cameraLook.z;
        float pz = vx * cameraLook.y - vy * cameraLook.x;
        float plen = (float)Math.sqrt(px * px + py * py + pz * pz);
        if (plen < 1.0E-4f && (plen = (float)Math.sqrt((px = vy * (uz = 0.0f) - vz * (uy = 1.0f)) * px + (py = vz * (ux = 0.0f) - vx * uz) * py + (pz = vx * uy - vy * ux) * pz)) < 1.0E-4f) {
            return;
        }
        float inv = 1.0f / plen;
        double a1x = ax - (double)(px *= inv * half);
        double a1y = ay - (double)(py *= inv * half);
        double a1z = az - (double)(pz *= inv * half);
        double a2x = ax + (double)px;
        double a2y = ay + (double)py;
        double a2z = az + (double)pz;
        double b1x = bx - (double)px;
        double b1y = by - (double)py;
        double b1z = bz - (double)pz;
        double b2x = bx + (double)px;
        double b2y = by + (double)py;
        double b2z = bz + (double)pz;
        CrossOverlayRenderer.drawVertex(currentMatrix, a1x - cameraX, a1y - cameraY, a1z - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, b1x - cameraX, b1y - cameraY, b1z - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, b2x - cameraX, b2y - cameraY, b2z - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, a1x - cameraX, a1y - cameraY, a1z - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, b2x - cameraX, b2y - cameraY, b2z - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, a2x - cameraX, a2y - cameraY, a2z - cameraZ, r, g, b);
    }

    private static void renderCross(PoseStack matrixstack, Matrix4f currentMatrix, double cameraX, double cameraY, double cameraZ, BlockPos pos, float r, float g, float b) {
        LocalPlayer player = CrossOverlayRenderer.minecraft.player;
        if (player == null) {
            return;
        }
        BlockState blockStateBelow = player.level().getBlockState(pos);
        float y = blockStateBelow.is(BlockTags.SNOW) ? ((double)pos.getY() > player.getY() ? 0.005f + ((float)pos.getY() + 0.125f) : (float)((double)(0.005f + ((float)pos.getY() + 0.125f)) + (double)0.01f * -((double)pos.getY() - player.getY() - 1.0))) : ((double)pos.getY() > player.getY() ? 0.005f + (float)pos.getY() : (float)((double)(0.005f + (float)pos.getY()) + (double)0.01f * -((double)pos.getY() - player.getY() - 1.0)));
        int x0 = pos.getX();
        int x1 = x0 + 1;
        int z0 = pos.getZ();
        int z1 = z0 + 1;
        CrossOverlayRenderer.drawVertex(currentMatrix, (double)x0 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, (double)x1 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, (double)x1 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, (double)x0 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
    }

    @Override
    public void renderOverlays(ILightScanner scanner, PoseStack matrixstack) {
        boolean notFabulous;
        Minecraft.getInstance().getTextureManager().bindForSetup(BLANK_TEX);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        boolean bl = notFabulous = Minecraft.getInstance().options.graphicsMode().get() != GraphicsStatus.FABULOUS;
        if (notFabulous) {
            RenderSystem.depthMask((boolean)false);
        }
        float ar = (float)((Integer)Config.render_spawnAColor.get() >> 16 & 0xFF) / 255.0f;
        float ag = (float)((Integer)Config.render_spawnAColor.get() >> 8 & 0xFF) / 255.0f;
        float ab = (float)((Integer)Config.render_spawnAColor.get() & 0xFF) / 255.0f;
        float nr = (float)((Integer)Config.render_spawnNColor.get() >> 16 & 0xFF) / 255.0f;
        float ng = (float)((Integer)Config.render_spawnNColor.get() >> 8 & 0xFF) / 255.0f;
        float nb = (float)((Integer)Config.render_spawnNColor.get() & 0xFF) / 255.0f;
        double configuredWidth = (Double)Config.render_spawnLineWidth.get();
        boolean useDebugLines = configuredWidth <= 2.0;
        RenderSystem.lineWidth((float)1.0f);
        if (notFabulous) {
            if (useDebugLines) {
                RenderSystem.enableCull();
            } else {
                RenderSystem.disableCull();
            }
        }
        renderer = tess.begin(useDebugLines ? VertexFormat.Mode.DEBUG_LINES : VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        Camera camera = CrossOverlayRenderer.minecraft.gameRenderer.getMainCamera();
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        Matrix4f currentMatrix = matrixstack.last().pose();
        Vector3f look = camera.getLookVector();
        float cullCos = (float)Math.cos(Math.toRadians(105.0));
        for (Pair<BlockPos, Byte> entry : scanner.getLightModes()) {
            Byte mode = (Byte)entry.getValue();
            if (mode == null || mode == 0) continue;
            BlockPos bp = (BlockPos)entry.getKey();
            float vx = (float)((double)bp.getX() + 0.5 - cameraX);
            float vy = (float)((double)bp.getY() + 0.5 - cameraY);
            float vz = (float)((double)bp.getZ() + 0.5 - cameraZ);
            float vLenInv = 1.0f / (float)Math.max(1.0E-6, Math.sqrt(vx * vx + vy * vy + vz * vz));
            float dot = vx * look.x + vy * look.y + vz * look.z;
            if ((dot *= vLenInv) < cullCos) continue;
            if (useDebugLines) {
                if (mode == 1) {
                    CrossOverlayRenderer.renderCross(matrixstack, currentMatrix, cameraX, cameraY, cameraZ, bp, nr, ng, nb);
                    continue;
                }
                if (mode != 2) continue;
                CrossOverlayRenderer.renderCross(matrixstack, currentMatrix, cameraX, cameraY, cameraZ, bp, ar, ag, ab);
                continue;
            }
            float r = mode == 1 ? nr : ar;
            float g = mode == 1 ? ng : ag;
            float b = mode == 1 ? nb : ab;
            int x0 = bp.getX();
            int x1 = x0 + 1;
            int z0 = bp.getZ();
            int z1 = z0 + 1;
            LocalPlayer player = CrossOverlayRenderer.minecraft.player;
            if (player == null) continue;
            BlockState blockStateBelow = player.level().getBlockState(bp);
            float y = blockStateBelow.is(BlockTags.SNOW) ? ((double)bp.getY() > player.getY() ? 0.005f + ((float)bp.getY() + 0.125f) : (float)((double)(0.005f + ((float)bp.getY() + 0.125f)) + (double)0.01f * -((double)bp.getY() - player.getY() - 1.0))) : ((double)bp.getY() > player.getY() ? 0.005f + (float)bp.getY() : (float)((double)(0.005f + (float)bp.getY()) + (double)0.01f * -((double)bp.getY() - player.getY() - 1.0)));
            double desiredPixelWidth = 1.0 + Math.max(0.0, configuredWidth - 2.0) * 0.1;
            CrossOverlayRenderer.addThickLine(currentMatrix, look, cameraX, cameraY, cameraZ, x0, y, z0, x1, y, z1, r, g, b, desiredPixelWidth);
            CrossOverlayRenderer.addThickLine(currentMatrix, look, cameraX, cameraY, cameraZ, x1, y, z0, x0, y, z1, r, g, b, desiredPixelWidth);
        }
        MeshData meshData = renderer.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        RenderSystem.depthMask((boolean)true);
        if (notFabulous) {
            RenderSystem.disableCull();
        } else {
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.enableBlend();
        }
    }
}

