/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.gui.config;

import at.ridgo8.moreoverlays.gui.config.ConfigOptionList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;

public abstract class OptionValueEntry<V>
extends ConfigOptionList.OptionEntry {
    public static final int CONTROL_WIDTH_NOVALIDATOR = 44;
    public static final int CONTROL_WIDTH_VALIDATOR = 64;
    public static final int TITLE_WIDTH = 160;
    protected final ModConfigSpec.ConfigValue<V> value;
    protected final ModConfigSpec.ValueSpec spec;
    private final List<String> tooltip;
    protected Button btnReset;
    protected Button btnUndo;
    protected V defaultValue;
    protected V newValue;
    protected boolean showValidity = false;
    private String txtUndo = "";
    private String txtReset = "";
    private String name = "";
    private boolean valid = false;
    private boolean changes = false;

    public OptionValueEntry(ConfigOptionList list, ModConfigSpec.ConfigValue<V> confValue, ModConfigSpec.ValueSpec spec) {
        super(list);
        this.value = confValue;
        this.spec = spec;
        this.btnReset = new Button.Builder(Component.nullToEmpty((String)"\u2604"), btn -> this.reset()).pos(list.getRowWidth() - 20, 0).size(20, 20).build();
        this.btnUndo = new Button.Builder(Component.nullToEmpty((String)"\u21b6"), btn -> this.undo()).pos(list.getRowWidth() - 42, 0).size(20, 20).build();
        this.txtReset = I18n.get((String)"gui.config.moreoverlays.reset_config", (Object[])new Object[0]);
        this.txtUndo = I18n.get((String)"gui.config.moreoverlays.undo", (Object[])new Object[0]);
        Object defaultVal = this.spec.getDefault();
        if (defaultVal != null && spec.getClazz().isAssignableFrom(defaultVal.getClass())) {
            this.defaultValue = defaultVal;
        } else {
            this.btnReset.active = false;
        }
        String translationKey = "config.moreoverlays." + this.getTranslationKey().toLowerCase();
        this.name = I18n.exists((String)translationKey) ? I18n.get((String)translationKey, (Object[])new Object[0]) : (String)this.value.getPath().get(this.value.getPath().size() - 1);
        String[] lines = null;
        if (this.spec.getComment() != null) {
            lines = this.spec.getComment().split("\\n");
            this.tooltip = new ArrayList<String>(lines.length + 1);
        } else {
            this.tooltip = new ArrayList<String>(1);
        }
        this.tooltip.add(String.valueOf(ChatFormatting.RED) + this.name);
        if (lines != null) {
            for (String line : lines) {
                this.tooltip.add(String.valueOf(ChatFormatting.YELLOW) + line);
            }
        }
        this.updateValue(this.value.get());
    }

    private String getTranslationKey() {
        return String.join((CharSequence)".", this.value.getPath());
    }

    @Override
    protected void renderControls(GuiGraphics guiGraphics, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
        int rightEdge = rowLeft + 160 - 5;
        Font font = Minecraft.getInstance().font;
        int startX = rightEdge - font.width(this.name);
        if (startX < rowLeft + 4) {
            startX = rowLeft + 4;
        }
        guiGraphics.drawString(font, this.name, startX, rowTop + 6, 0xFFFFFF);
        this.btnReset.setPosition(rowLeft + this.getConfigOptionList().getRowWidth() - 20, rowTop);
        this.btnUndo.setPosition(rowLeft + this.getConfigOptionList().getRowWidth() - 42, rowTop);
        this.btnReset.render(guiGraphics, mouseX, mouseY, partialTick);
        this.btnUndo.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.showValidity) {
            int validityX = rowLeft + this.getConfigOptionList().getRowWidth() - 53;
            int validityY = rowTop + 6;
            if (this.valid) {
                guiGraphics.drawCenteredString(font, "\u2714", validityX, validityY, 65280);
            } else {
                guiGraphics.drawCenteredString(font, "\u2715", validityX, validityY, 0xFF0000);
            }
        }
    }

    @Override
    protected void renderTooltip(GuiGraphics guiGraphics, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, rowTop, rowLeft, rowWidth, itemHeight, mouseX, mouseY);
        ArrayList<Component> tooltipConverted = new ArrayList<Component>();
        for (String iTextComponent : this.tooltip) {
            tooltipConverted.add(Component.nullToEmpty((String)iTextComponent));
        }
        if (this.btnReset.isHoveredOrFocused()) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, Component.nullToEmpty((String)this.txtReset), mouseX, mouseY);
        } else if (this.btnUndo.isHoveredOrFocused()) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, Component.nullToEmpty((String)this.txtUndo), mouseX, mouseY);
        } else if (mouseX < 160 + rowLeft) {
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, tooltipConverted, mouseX, mouseY);
        }
    }

    protected abstract void overrideUnsaved(V var1);

    protected boolean isUndoable(V current) {
        return current == null || !current.equals(this.value.get()) || !this.valid;
    }

    protected void updateValue(@Nullable V value) {
        this.valid = value != null && this.spec.test(value);
        this.btnReset.active = this.isResettable();
        this.btnUndo.active = this.changes = this.isUndoable(value);
        this.newValue = value;
    }

    @Override
    public void undo() {
        this.overrideUnsaved(this.value.get());
        this.updateValue(this.value.get());
    }

    @Override
    public void reset() {
        if (this.defaultValue != null) {
            this.value.set(this.defaultValue);
            this.overrideUnsaved(this.defaultValue);
            this.updateValue(this.defaultValue);
        }
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return Arrays.asList(this.btnReset, this.btnUndo);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean hasChanges() {
        return this.changes;
    }

    @Override
    public boolean isResettable() {
        return this.defaultValue != null && (this.value.get() == null || !this.value.get().equals(this.defaultValue));
    }

    @Override
    public void save() {
        this.value.set(this.newValue);
        this.value.save();
    }
}

