/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.gui.config;

import at.ridgo8.moreoverlays.MoreOverlays;
import at.ridgo8.moreoverlays.gui.ConfigScreen;
import at.ridgo8.moreoverlays.gui.config.OptionBoolean;
import at.ridgo8.moreoverlays.gui.config.OptionCategory;
import at.ridgo8.moreoverlays.gui.config.OptionColor;
import at.ridgo8.moreoverlays.gui.config.OptionGeneric;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigOptionList
extends ContainerObjectSelectionList<OptionEntry> {
    public static final String UNDO_CHAR = "\u21b6";
    public static final String RESET_CHAR = "\u2604";
    public static final String VALID = "\u2714";
    public static final String INVALID = "\u2715";
    private static final int ITEM_HEIGHT = 22;
    private final ConfigScreen parent;
    private final String modId;
    private ModConfigSpec rootConfig;
    private List<String> configPath = Collections.emptyList();
    private Map<String, Object> currentMap;
    private CommentedConfig comments;

    public ConfigOptionList(Minecraft minecraft, String modId, ConfigScreen configs) {
        super(minecraft, configs.width, configs.height - 32 - 43, 43, 22);
        this.parent = configs;
        this.modId = modId;
    }

    public static List<String> splitPath(String path) {
        return Arrays.asList(path.split("\\."));
    }

    public ConfigScreen getScreen() {
        return this.parent;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition();
    }

    public int getRowWidth() {
        return super.getRowWidth() + 64 + 80;
    }

    public void updateGui() {
        this.setSize(this.parent.width, this.parent.height - 32 - 43);
    }

    protected void renderDecorations(GuiGraphics guiGraphics, int p_renderDecorations_1_, int p_renderDecorations_2_) {
        int i = this.getItemCount();
        for (int j = 0; j < i; ++j) {
            int k = this.getRowTop(j);
            int l = this.getRowTop(j) + 22;
            if (l < this.getY() || k > this.getBottom()) continue;
            OptionEntry e = (OptionEntry)this.getEntry(j);
            e.runRenderTooltip(guiGraphics);
        }
    }

    public String categoryTitleKey(List<String> path) {
        if (path.isEmpty()) {
            return null;
        }
        return "config." + this.modId + ".category." + path.stream().collect(Collectors.joining("."));
    }

    public void setConfiguration(ModConfigSpec rootConfig) {
        this.setConfiguration(rootConfig, Collections.emptyList());
    }

    public void setConfiguration(ModConfigSpec rootConfig, List<String> path) {
        this.rootConfig = rootConfig;
        try {
            Field loadedConfigField = ModConfigSpec.class.getDeclaredField("loadedConfig");
            loadedConfigField.setAccessible(true);
            IConfigSpec.ILoadedConfig loadedConfig = (IConfigSpec.ILoadedConfig)loadedConfigField.get(rootConfig);
            if (loadedConfig.config() instanceof CommentedConfig) {
                this.comments = loadedConfig.config();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | IllegalStateException | NoSuchFieldException | SecurityException e) {
            MoreOverlays.logger.warn("Couldn't reflect childConfig from ModConfigSpec! Comments will be missing.", (Throwable)e);
        }
        this.updatePath(path);
    }

    private void setPath(List<String> path) {
        Object val = path.isEmpty() ? this.rootConfig.getValues() : this.rootConfig.getValues().getRaw(path);
        if (!(val instanceof UnmodifiableConfig)) {
            int n = path.size();
            if (n > 1 && path.get(n - 1) == path.get(n - 2)) {
                MoreOverlays.logger.error("Attempting to load duplicate path:", path);
                MoreOverlays.logger.warn("This could be caused by key event race condition");
                path.remove(n - 1);
                this.setPath(path);
                return;
            }
            throw new IllegalArgumentException("Path in config list has to point to another config object");
        }
        this.configPath = path;
        this.currentMap = val.valueMap();
        this.refreshEntries();
        this.parent.updatePath(this.getCurrentPath());
    }

    public void updatePath(List<String> path) {
        this.setPath(new ArrayList<String>(path));
    }

    public void push(String path) {
        this.push(ConfigOptionList.splitPath(path));
    }

    public void push(List<String> path) {
        ArrayList<String> tmp = new ArrayList<String>(this.configPath.size() + path.size());
        tmp.addAll(this.configPath);
        tmp.addAll(path);
        this.setPath(tmp);
    }

    public void pop() {
        this.pop(1);
    }

    public void pop(int amount) {
        ArrayList<String> tmp = new ArrayList<String>(this.configPath);
        for (int i = 0; i < amount && !tmp.isEmpty(); ++i) {
            tmp.remove(tmp.size() - 1);
        }
        this.setPath(tmp);
        this.setScrollAmount(0.0);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        boolean flag = super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        OptionEntry selected = (OptionEntry)this.getEntryAtPosition(p_mouseClicked_1_, p_mouseClicked_3_);
        for (OptionEntry entry : this.children()) {
            if (entry == selected) continue;
            entry.setFocused(null);
        }
        return flag;
    }

    public void refreshEntries() {
        this.clearEntries();
        for (Map.Entry<String, Object> cEntry : this.currentMap.entrySet()) {
            ArrayList<String> fullPath = new ArrayList<String>(this.configPath.size() + 1);
            fullPath.addAll(this.configPath);
            fullPath.add(cEntry.getKey());
            if (fullPath.size() == 2 && "lightoverlay".equals(fullPath.get(0)) && "finishedMigration".equalsIgnoreCase((String)fullPath.get(1))) continue;
            String comment = null;
            if (this.comments != null) {
                comment = this.comments.getComment(fullPath);
            }
            if (cEntry.getValue() instanceof UnmodifiableConfig) {
                String name = I18n.get((String)this.categoryTitleKey(fullPath), (Object[])new Object[0]);
                this.addEntry((AbstractSelectionList.Entry)new OptionCategory(this, Arrays.asList(cEntry.getKey()), name, comment));
                continue;
            }
            if (cEntry.getValue() instanceof ModConfigSpec.BooleanValue) {
                this.addEntry((AbstractSelectionList.Entry)new OptionBoolean(this, (ModConfigSpec.BooleanValue)cEntry.getValue(), (ModConfigSpec.ValueSpec)this.rootConfig.getSpec().get(fullPath)));
                continue;
            }
            if (cEntry.getValue() instanceof ModConfigSpec.IntValue && cEntry.getKey().toLowerCase().contains("color")) {
                this.addEntry((AbstractSelectionList.Entry)new OptionColor(this, (ModConfigSpec.IntValue)cEntry.getValue(), (ModConfigSpec.ValueSpec)this.rootConfig.getSpec().get(fullPath)));
                continue;
            }
            this.addEntry((AbstractSelectionList.Entry)new OptionGeneric(this, (ModConfigSpec.ConfigValue)cEntry.getValue(), (ModConfigSpec.ValueSpec)this.rootConfig.getSpec().get(fullPath)));
        }
        this.setFocused(null);
    }

    public List<String> getCurrentPath() {
        return Collections.unmodifiableList(this.configPath);
    }

    public ModConfigSpec getConfig() {
        return this.rootConfig;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isSaveable() {
        boolean hasChanges = false;
        for (OptionEntry entry : this.children()) {
            if (!entry.isValid()) {
                return false;
            }
            hasChanges = hasChanges || entry.hasChanges();
        }
        return hasChanges;
    }

    public boolean isResettable() {
        boolean resettable = false;
        for (OptionEntry entry : this.children()) {
            resettable = resettable || entry.isResettable();
        }
        return resettable;
    }

    public boolean isUndoable() {
        boolean hasChanges = false;
        for (OptionEntry entry : this.children()) {
            hasChanges = hasChanges || entry.hasChanges();
        }
        return hasChanges;
    }

    public void reset() {
        for (OptionEntry entry : this.children()) {
            entry.reset();
        }
    }

    public void undo() {
        for (OptionEntry entry : this.children()) {
            entry.undo();
        }
    }

    public void save() {
        for (OptionEntry entry : this.children()) {
            if (!entry.isValid()) continue;
            entry.save();
        }
    }

    public static abstract class OptionEntry
    extends ContainerObjectSelectionList.Entry<OptionEntry>
    implements ContainerEventHandler {
        private final ConfigOptionList optionList;
        protected int rowTop;
        protected int rowLeft;
        private int rowWidth;
        private int itemHeight;
        private int mouseX;
        private int mouseY;
        private boolean mouseOver;

        public OptionEntry(ConfigOptionList list) {
            this.optionList = list;
        }

        public void render(GuiGraphics guiGraphics, int itemindex, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
            this.rowTop = rowTop;
            this.rowLeft = rowLeft;
            this.rowWidth = rowWidth;
            this.itemHeight = itemHeight;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.mouseOver = mouseOver;
            this.renderControls(guiGraphics, rowTop, rowLeft, rowWidth, itemHeight, mouseX, mouseY, mouseOver, partialTick);
        }

        protected abstract void renderControls(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public void runRenderTooltip(GuiGraphics guiGraphics) {
            if (this.mouseOver) {
                this.renderTooltip(guiGraphics, this.rowTop, this.rowLeft, this.rowWidth, this.itemHeight, this.mouseX, this.mouseY);
                Lighting.setupForFlatItems();
                GlStateManager._disableBlend();
            }
        }

        protected void renderTooltip(GuiGraphics guiGraphics, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY) {
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public ConfigOptionList getConfigOptionList() {
            return this.optionList;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(mouseX, mouseY, button);
        }

        public boolean mouseDragged(double fromX, double fromY, int button, double toX, double toY) {
            return super.mouseDragged(fromX, fromY, button, toX, toY);
        }

        public boolean isDragging() {
            return false;
        }

        public void setDragging(boolean dragging) {
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double amount, double unknown) {
            return super.mouseScrolled(mouseX, mouseY, amount, unknown);
        }

        public boolean isValid() {
            return true;
        }

        public boolean hasChanges() {
            return false;
        }

        public boolean isResettable() {
            return false;
        }

        public void reset() {
        }

        public void undo() {
        }

        public void save() {
        }
    }
}

