/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import reliquary.entity.shot.ShotBase;
import reliquary.init.ModDataComponents;
import reliquary.init.ModItems;
import reliquary.init.ModSounds;
import reliquary.item.BulletItem;
import reliquary.item.ItemBase;
import reliquary.item.MagazineItem;
import reliquary.reference.Config;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;
import reliquary.util.potions.PotionHelper;

public class HandgunItem
extends ItemBase {
    private static final int HANDGUN_RELOAD_SKILL_OFFSET = 10;
    private static final int HANDGUN_COOLDOWN_SKILL_OFFSET = 5;
    private final Map<ResourceLocation, IShotFactory> magazineShotFactories = new HashMap<ResourceLocation, IShotFactory>();
    private final Map<ResourceLocation, Supplier<BulletItem>> magazineBulletItems = new HashMap<ResourceLocation, Supplier<BulletItem>>();

    public void registerMagazine(ResourceLocation magazineRegistryName, IShotFactory factory, Supplier<BulletItem> getBulletItem) {
        this.magazineShotFactories.put(magazineRegistryName, factory);
        this.magazineBulletItems.put(magazineRegistryName, getBulletItem);
    }

    public HandgunItem() {
        super(new Item.Properties().stacksTo(1), (Supplier<Boolean>)Config.COMMON.disable.disableHandgun);
    }

    private short getBulletCount(ItemStack handgun) {
        return (Short)handgun.getOrDefault(ModDataComponents.BULLET_COUNT, (Object)0);
    }

    public ItemStack getBulletStack(ItemStack handgun) {
        return this.getMagazineType(handgun).map(magazineType -> {
            if (!this.magazineBulletItems.containsKey(magazineType)) {
                return new ItemStack((ItemLike)ModItems.EMPTY_BULLET.get(), 1);
            }
            BulletItem bulletItem = this.magazineBulletItems.get(magazineType).get();
            ItemStack bulletStack = new ItemStack((ItemLike)bulletItem, (int)this.getBulletCount(handgun));
            bulletStack.set(DataComponents.POTION_CONTENTS, (Object)this.getPotionContents(handgun));
            return bulletStack;
        }).orElseGet(() -> new ItemStack((ItemLike)ModItems.EMPTY_BULLET.get(), 1));
    }

    private void setBulletCount(ItemStack handgun, short bulletCount) {
        handgun.set(ModDataComponents.BULLET_COUNT, (Object)bulletCount);
    }

    private Optional<ResourceLocation> getMagazineType(ItemStack handgun) {
        return Optional.ofNullable((ResourceLocation)handgun.get(ModDataComponents.MAGAZINE_TYPE));
    }

    private void setMagazineType(ItemStack handgun, ItemStack magazine) {
        handgun.set(ModDataComponents.MAGAZINE_TYPE, (Object)RegistryHelper.getRegistryName(magazine.getItem()));
    }

    private boolean hasAmmo(ItemStack handgun) {
        return this.getBulletCount(handgun) > 0;
    }

    public long getCooldown(ItemStack handgun) {
        return (Long)handgun.getOrDefault(ModDataComponents.COOLDOWN_TIME, (Object)0L);
    }

    private void setCooldown(ItemStack handgun, long coolDownTime) {
        handgun.set(ModDataComponents.COOLDOWN_TIME, (Object)coolDownTime);
    }

    private PotionContents getPotionContents(ItemStack handgun) {
        return (PotionContents)handgun.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    private void setPotionEffects(ItemStack handgun, PotionContents potionEffects) {
        PotionHelper.cleanPotionEffects(handgun);
        PotionHelper.addPotionContentsToStack(handgun, potionEffects);
    }

    @Override
    protected void addMoreInformation(ItemStack handgun, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        if (this.hasAmmo(handgun)) {
            tooltipBuilder.data(this, ".tooltip2", this.getBulletCount(handgun), this.getMagazineName(handgun)).potionEffects(handgun);
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack handgun) {
        return this.hasAmmo(handgun);
    }

    private String getMagazineName(ItemStack handgun) {
        return this.getMagazineType(handgun).map(magazineType -> ((Item)BuiltInRegistries.ITEM.get(magazineType)).getName(new ItemStack((ItemLike)Items.AIR)).getString()).orElse("");
    }

    public UseAnim getUseAnimation(ItemStack handgun) {
        if (this.getBulletCount(handgun) > 0) {
            return UseAnim.NONE;
        }
        return UseAnim.BLOCK;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem() || this.getBulletCount(oldStack) < this.getBulletCount(newStack);
    }

    private boolean isCooldownOver(Level level, ItemStack handgun) {
        return this.getCooldown(handgun) < level.getGameTime();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack handgun = player.getItemInHand(hand);
        if (this.getBulletCount(handgun) > 0 && !this.isCooldownOver(level, handgun) && this.otherHandgunCooledDownMore(player, hand, handgun)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)handgun);
        }
        if (this.getBulletCount(handgun) > 0 || this.hasFilledMagazine(player)) {
            player.startUsingItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)handgun);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)handgun);
    }

    private boolean otherHandgunCooledDownMore(Player player, InteractionHand currentHand, ItemStack currentHandgun) {
        if (currentHand == InteractionHand.MAIN_HAND) {
            ItemStack offHandItem = player.getOffhandItem();
            return offHandItem.getItem() == this && this.getCooldown(offHandItem) < this.getCooldown(currentHandgun);
        }
        ItemStack mainHandItem = player.getMainHandItem();
        return mainHandItem.getItem() == this && this.getCooldown(mainHandItem) < this.getCooldown(currentHandgun);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack handgun, int remainingUseDuration) {
        if (livingEntity.level().isClientSide || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int maxUseOffset = this.getItemUseDuration() - this.getPlayerReloadDelay(player);
        int actualCount = remainingUseDuration - maxUseOffset;
        if (--actualCount == 0 || this.isCooldownOver(livingEntity.level(), handgun) && this.getBulletCount(handgun) > 0) {
            player.releaseUsingItem();
        }
    }

    public int getUseDuration(ItemStack handgun, LivingEntity livingEntity) {
        return this.getItemUseDuration();
    }

    public void releaseUsing(ItemStack handgun, Level level, LivingEntity livingEntity, int timeLeft) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.hasAmmo(handgun)) {
            if (this.isCooldownOver(player.level(), handgun)) {
                this.setFiringCooldown(handgun, level, player);
                this.fireBullet(handgun, level, player, handgun == player.getMainHandItem() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            }
            return;
        }
        this.setCooldown(handgun, player.level().getGameTime() + 12L);
        this.getMagazineSlot(player).ifPresent(slot -> {
            ItemStack magazine = (ItemStack)player.getInventory().items.get(slot.intValue());
            this.setMagazineType(handgun, magazine);
            this.setPotionEffects(handgun, (PotionContents)magazine.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY));
            magazine.shrink(1);
            if (magazine.isEmpty()) {
                player.getInventory().items.set(slot.intValue(), (Object)ItemStack.EMPTY);
            }
            player.swing(player.getUsedItemHand());
            this.spawnEmptyMagazine(player);
            this.setBulletCount(handgun, (short)8);
            player.level().playSound(null, player.blockPosition(), ModSounds.HANDGUN_LOAD.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
            this.setFiringCooldown(handgun, level, player);
        });
        if (this.getBulletCount(handgun) == 0) {
            this.setPotionEffects(handgun, PotionContents.EMPTY);
        }
    }

    private void setSecondHandgunFiringCooldown(Player player, ItemStack currentHandgun) {
        if (player.getMainHandItem() == currentHandgun) {
            this.setHalfFiringCooldown(player, player.getOffhandItem());
        } else if (player.getOffhandItem() == currentHandgun) {
            this.setHalfFiringCooldown(player, player.getMainHandItem());
        }
    }

    private void setHalfFiringCooldown(Player player, ItemStack potentialHandgun) {
        if (potentialHandgun.getItem() == this && this.isCooldownOver(player.level(), potentialHandgun)) {
            this.setCooldown(potentialHandgun, player.level().getGameTime() + (long)(this.getPlayerFiringCooldown(player) / 2));
        }
    }

    private void setFiringCooldown(ItemStack handgun, Level level, Player player) {
        this.setCooldown(handgun, level.getGameTime() + (long)this.getPlayerFiringCooldown(player));
        this.setSecondHandgunFiringCooldown(player, handgun);
    }

    private int getPlayerFiringCooldown(Player player) {
        return (Integer)Config.COMMON.items.handgun.maxSkillLevel.get() + 5 - Math.min(player.experienceLevel, (Integer)Config.COMMON.items.handgun.maxSkillLevel.get());
    }

    private int getItemUseDuration() {
        return 10 + (Integer)Config.COMMON.items.handgun.maxSkillLevel.get();
    }

    private void fireBullet(ItemStack handgun, Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            this.getMagazineType(handgun).filter(this.magazineShotFactories::containsKey).ifPresent(magazineType -> {
                this.spawnShotEntity(handgun, level, player, hand, (ResourceLocation)magazineType);
                level.playSound(null, player.blockPosition(), ModSounds.HANDGUN_SHOT.get(), SoundSource.PLAYERS, 0.5f, 1.2f);
                this.setBulletCount(handgun, (short)(this.getBulletCount(handgun) - 1));
                if (this.getBulletCount(handgun) == 0) {
                    this.setPotionEffects(handgun, PotionContents.EMPTY);
                }
                this.spawnCasing(player);
            });
        }
    }

    private void spawnShotEntity(ItemStack handgun, Level level, Player player, InteractionHand hand, ResourceLocation magazineType) {
        if (!this.magazineShotFactories.containsKey(magazineType)) {
            return;
        }
        ShotBase shot = this.magazineShotFactories.get(magazineType).createShot(level, player, hand).addPotionContents(this.getPotionContents(handgun));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int simulationDistance = serverLevel.getServer().getPlayerList().getSimulationDistance();
            HitResult hitResult = player.pick((double)simulationDistance, 1.0f, false);
            float velocity = 1.2f;
            float inaccuracy = 0.2f;
            if (hitResult.getType() != HitResult.Type.MISS) {
                shot.shoot(hitResult.getLocation().x - shot.getX(), hitResult.getLocation().y - shot.getY(), hitResult.getLocation().z - shot.getZ(), velocity, inaccuracy);
            } else {
                double motionX = -Mth.sin((float)(player.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(player.getXRot() / 180.0f * (float)Math.PI));
                double motionZ = Mth.cos((float)(player.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(player.getXRot() / 180.0f * (float)Math.PI));
                double motionY = -Mth.sin((float)(player.getXRot() / 180.0f * (float)Math.PI));
                shot.shoot(motionX, motionY, motionZ, velocity, inaccuracy);
            }
        }
        level.addFreshEntity((Entity)shot);
    }

    private void spawnEmptyMagazine(Player player) {
        ItemStack emptyMagazine = new ItemStack((ItemLike)ModItems.EMPTY_MAGAZINE.get());
        if (!player.getInventory().add(emptyMagazine)) {
            player.spawnAtLocation(emptyMagazine, 0.1f);
        }
    }

    private void spawnCasing(Player player) {
        ItemStack emptyCasing = new ItemStack((ItemLike)ModItems.EMPTY_BULLET.get());
        if (!player.getInventory().add(emptyCasing)) {
            player.spawnAtLocation(emptyCasing, 0.1f);
        }
    }

    private boolean hasFilledMagazine(Player player) {
        for (ItemStack stack : player.getInventory().items) {
            if (stack == null || !(stack.getItem() instanceof MagazineItem) || stack.getItem() == ModItems.EMPTY_MAGAZINE.get()) continue;
            return true;
        }
        return false;
    }

    private Optional<Integer> getMagazineSlot(Player player) {
        for (int slot = 0; slot < player.getInventory().items.size(); ++slot) {
            Item item = ((ItemStack)player.getInventory().items.get(slot)).getItem();
            if (!(item instanceof MagazineItem) || item == ModItems.EMPTY_MAGAZINE.get()) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }

    private int getPlayerReloadDelay(Player player) {
        return (Integer)Config.COMMON.items.handgun.maxSkillLevel.get() + 10 - Math.min(player.experienceLevel, (Integer)Config.COMMON.items.handgun.maxSkillLevel.get());
    }

    public static interface IShotFactory {
        public ShotBase createShot(Level var1, Player var2, InteractionHand var3);
    }
}

