/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import reliquary.entity.shot.ShotBase;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.reference.Config;

public class InterdictionTorchBlock
extends TorchBlock
implements ICreativeTabItemGenerator {
    protected static final int TICK_RATE = 1;

    public InterdictionTorchBlock() {
        super(ParticleTypes.FLAME, BlockBehaviour.Properties.of().strength(0.0f).lightLevel(value -> 15).randomTicks().sound(SoundType.WOOD).noCollission());
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public MutableComponent getName() {
        return super.getName().withStyle(ChatFormatting.YELLOW);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 1);
        super.onPlace(state, level, pos, oldState, isMoving);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        level.scheduleTick(pos, (Block)this, 1);
        if (level.isClientSide) {
            return;
        }
        int radius = (Integer)Config.COMMON.blocks.interdictionTorch.pushRadius.get();
        List entities = level.getEntitiesOfClass(Entity.class, new AABB(pos).inflate((double)radius), e -> e instanceof Mob || e instanceof Projectile);
        for (Entity entity : entities) {
            double distance;
            if (entity instanceof Player || entity instanceof ShotBase || entity instanceof FishingHook || this.isBlacklistedEntity(entity) || !((distance = Math.sqrt(entity.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()))) < (double)radius) || distance == 0.0) continue;
            this.moveEntity(pos, entity, distance);
        }
    }

    private void moveEntity(BlockPos pos, Entity entity, double distance) {
        if (distance < 1.0) {
            distance = 1.0;
        }
        double knockbackMultiplier = 1.0 + 1.0 / distance;
        double reductionCoefficient = 0.04;
        Vec3 angleOfAttack = entity.position().add(-((double)pos.getX() + 0.5), (double)(-pos.getY()), -((double)pos.getZ() + 0.5));
        double xForce = angleOfAttack.x * knockbackMultiplier * reductionCoefficient;
        double yForce = angleOfAttack.y * knockbackMultiplier * reductionCoefficient;
        double zForce = angleOfAttack.z * knockbackMultiplier * reductionCoefficient;
        entity.setDeltaMovement(entity.getDeltaMovement().add(xForce, yForce, zForce));
    }

    private boolean isBlacklistedEntity(Entity entity) {
        String entityName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
        return this.isBlacklistedLivingEntity(entity, entityName) || (Boolean)Config.COMMON.blocks.interdictionTorch.canPushProjectiles.get() != false && this.isBlacklistedProjectile(entity, entityName);
    }

    private boolean isBlacklistedProjectile(Entity entity, String entityName) {
        return entity instanceof Projectile && ((List)Config.COMMON.blocks.interdictionTorch.pushableProjectilesBlacklist.get()).contains(entityName);
    }

    private boolean isBlacklistedLivingEntity(Entity entity, String entityName) {
        return entity instanceof Mob && ((List)Config.COMMON.blocks.interdictionTorch.pushableEntitiesBlacklist.get()).contains(entityName);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double xOffset = (float)pos.getX() + 0.5f;
        double yOffset = (float)pos.getY() + 0.7f;
        double zOffset = (float)pos.getZ() + 0.5f;
        level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.opaque((int)0)), xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
    }
}

