/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineSkillHandler;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record MaxPerkUnlocker(int maxPerkPoints, ResourceLocation taskName) implements TaskUnlocker
{
    public static final MapCodec<MaxPerkUnlocker> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("maxPerkPoints").forGetter(i -> i.maxPerkPoints), (App)ResourceLocation.CODEC.fieldOf("taskName").forGetter(t -> t.taskName)).apply((Applicative)inst, MaxPerkUnlocker::new));

    public Component getDescription() {
        return Component.translatable((String)"text.bloodlines.max_perk_points", (Object[])new Object[]{this.maxPerkPoints});
    }

    public boolean isUnlocked(IFactionPlayer<?> iFactionPlayer) {
        Player entity = iFactionPlayer.asEntity();
        BloodlineSkillHandler skillHandler = BloodlineManager.get(entity).getSkillHandler();
        if (skillHandler != null) {
            int gainedPoints = skillHandler.getPointsFromSource(this.taskName);
            return gainedPoints <= this.maxPerkPoints;
        }
        return true;
    }

    public MapCodec<? extends TaskUnlocker> codec() {
        return CODEC;
    }
}

