/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.tasks.BloodlineTasks;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record BloodlineRankReward(int targetRank, ResourceLocation source) implements TaskReward,
ITaskRewardInstance
{
    public static final MapCodec<BloodlineRankReward> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("targetRank").forGetter(BloodlineRankReward::targetRank), (App)ResourceLocation.CODEC.fieldOf("source").forGetter(t -> t.source)).apply((Applicative)inst, BloodlineRankReward::new));

    public void applyReward(IFactionPlayer<?> p) {
        p.getTaskManager().resetUniqueTask(ResourceKey.create((ResourceKey)VampirismRegistries.Keys.TASK, (ResourceLocation)this.source));
        BloodlineManager.getOpt(p.asEntity()).ifPresent(bl -> {
            Player player = p.asEntity();
            if (bl.getRank() == this.targetRank - 1) {
                int oldRank = bl.getRank();
                bl.setRank(this.targetRank);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.ENTITY_VAMPIRE_SCREAM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                ModParticles.spawnParticlesServer((Level)player.level(), (ParticleOptions)new GenericParticleOptions(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"spell_1"), 50, 0x8B0000, 0.2f), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (int)100, (double)1.0, (double)1.0, (double)1.0, (double)0.0);
                bl.onBloodlineChange(bl.getBloodline(), oldRank);
            }
        });
    }

    @NotNull
    public ITaskRewardInstance createInstance(IFactionPlayer<?> player) {
        return this;
    }

    public MapCodec<BloodlineRankReward> codec() {
        return (MapCodec)BloodlineTasks.BLOODLINE_RANK_REWARD.get();
    }

    public Component description() {
        return null;
    }
}

