/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class ZealotShadowwalkAction
extends DefaultVampireAction {
    public boolean isEnabled() {
        return true;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        Player player = vampire.asEntity();
        if (!BloodlineHelper.lightMatches((Integer)CommonConfig.zealotShadowwalkLightLevel.get(), player.getOnPos().above(), player.getCommandSenderWorld(), true)) {
            player.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.current_light").withStyle(ChatFormatting.DARK_PURPLE), true);
            return false;
        }
        int dist = (Integer)VampirismConfig.BALANCE.vaTeleportMaxDistance.get();
        if (vampire.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.TELEPORT_DISTANCE.get())) {
            dist = (int)((double)dist * (Double)VampirismConfig.BALANCE.vrTeleportDistanceMod.get());
        }
        HitResult target = UtilLib.getPlayerLookingSpot((Player)player, (double)dist);
        double ox = player.getX();
        double oy = player.getY();
        double oz = player.getZ();
        if (target.getType() == HitResult.Type.MISS) {
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 1.0f, 1.0f);
            return false;
        }
        BlockPos pos = null;
        if (target.getType() == HitResult.Type.BLOCK) {
            if (player.getCommandSenderWorld().getBlockState(((BlockHitResult)target).getBlockPos()).blocksMotion()) {
                pos = ((BlockHitResult)target).getBlockPos().above();
            }
        } else if (player.getCommandSenderWorld().getBlockState(((EntityHitResult)target).getEntity().blockPosition()).blocksMotion()) {
            pos = ((EntityHitResult)target).getEntity().blockPosition();
        }
        if (pos != null) {
            if (!BloodlineHelper.lightMatches((Integer)CommonConfig.zealotShadowwalkLightLevel.get(), pos.above(), player.getCommandSenderWorld(), true)) {
                player.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.target_light").withStyle(ChatFormatting.DARK_PURPLE), true);
                return false;
            }
            player.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5);
            if (player.getCommandSenderWorld().containsAnyLiquid(player.getBoundingBox()) || !player.getCommandSenderWorld().isUnobstructed((Entity)player)) {
                pos = null;
            }
        }
        if (pos == null) {
            player.setPos(ox, oy, oz);
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), 1.0f, 1.0f);
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer playerMp = (ServerPlayer)player;
            playerMp.disconnect();
            playerMp.teleportTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5);
        }
        AreaParticleCloudEntity particleCloud = new AreaParticleCloudEntity((EntityType)ModEntities.PARTICLE_CLOUD.get(), player.getCommandSenderWorld());
        particleCloud.setPos(ox, oy, oz);
        particleCloud.setRadius(0.7f);
        particleCloud.setHeight(player.getBbHeight());
        particleCloud.setDuration(5);
        particleCloud.setSpawnRate(15.0f);
        player.getCommandSenderWorld().addFreshEntity((Entity)particleCloud);
        player.getCommandSenderWorld().playSound(null, ox, oy, oz, (SoundEvent)ModSounds.TELEPORT_AWAY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.getCommandSenderWorld().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.TELEPORT_HERE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    public boolean canBeUsedBy(IVampirePlayer player) {
        return !player.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get());
    }

    public int getCooldown(IVampirePlayer iVampirePlayer) {
        int rank = BloodlineManager.get(iVampirePlayer.asEntity()).getRank() - 1;
        return (Integer)((List)CommonConfig.zealotShadowwalkCooldowns.get()).get(rank) * 20;
    }
}

