/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class ZealotDarkCloakAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public boolean activate(IVampirePlayer vampire, IAction.ActivationContext context) {
        if (!BloodlineHelper.lightMatches((Integer)CommonConfig.zealotDarkCloakLightLevel.get(), vampire.asEntity().getOnPos().above(), vampire.asEntity().level(), true)) {
            vampire.asEntity().displayClientMessage((Component)Component.translatable((String)"text.bloodlines.current_light").withStyle(ChatFormatting.DARK_PURPLE), true);
            return false;
        }
        this.activate(vampire);
        return true;
    }

    protected void activate(IVampirePlayer player) {
        player.asEntity().setInvisible(true);
    }

    public int getCooldown(IVampirePlayer player) {
        return (Integer)CommonConfig.zealotDarkCloakCooldown.get() * 20;
    }

    public int getDuration(IVampirePlayer player) {
        return Mth.clamp((int)((Integer)CommonConfig.zealotDarkCloakDuration.get()), (int)10, (int)0x6666665) * 20;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void onActivatedClient(IVampirePlayer vampire) {
        ((VampirePlayer)vampire).getSpecialAttributes().invisible = true;
    }

    public void onDeactivated(IVampirePlayer vampire) {
        vampire.asEntity().setInvisible(false);
        ((VampirePlayer)vampire).getSpecialAttributes().invisible = false;
    }

    public void onReActivated(IVampirePlayer vampire) {
        this.activate(vampire);
    }

    public boolean onUpdate(IVampirePlayer vampire) {
        Player player = vampire.asEntity();
        if (!vampire.isRemote() && player.tickCount % 10 == 0 && !BloodlineHelper.lightMatches((Integer)CommonConfig.zealotDarkCloakLightLevel.get(), player.getOnPos().above(), player.level(), true)) {
            vampire.asEntity().displayClientMessage((Component)Component.translatable((String)"text.bloodlines.current_light").withStyle(ChatFormatting.DARK_PURPLE), true);
            return true;
        }
        if (player.isInvisible()) {
            player.setInvisible(true);
        }
        return false;
    }
}

