/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions;

import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class NobleFlankAction
extends DefaultVampireAction {
    public boolean isEnabled() {
        return true;
    }

    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        Player player = vampire.asEntity();
        int dist = (Integer)CommonConfig.nobleFlankRange.get();
        if (vampire.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.TELEPORT_DISTANCE.get())) {
            dist = (int)((double)dist * (Double)VampirismConfig.BALANCE.vrTeleportDistanceMod.get());
        }
        Vec3 eyePos = player.getEyePosition();
        Vec3 view = player.getViewVector(1.0f).scale((double)dist);
        Vec3 viewPos = eyePos.add(view);
        AABB aabb = player.getBoundingBox().expandTowards(view).inflate(1.0);
        EntityHitResult result = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eyePos, (Vec3)viewPos, (AABB)aabb, p -> p instanceof LivingEntity, (double)dist);
        double ox = player.getX();
        double oy = player.getY();
        double oz = player.getZ();
        if (result == null) {
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 1.0f, 1.0f);
            return false;
        }
        Vec3 pos = null;
        LivingEntity resultEntity = (LivingEntity)result.getEntity();
        if (player.isInvisible() || !UtilLib.canReallySee((LivingEntity)resultEntity, (LivingEntity)player, (boolean)false)) {
            Vec3 lookAngle = resultEntity.getViewVector(1.0f);
            Vec3 behindPos = lookAngle.reverse().multiply((double)1.2f, 0.0, (double)1.2f);
            pos = resultEntity.position().add(behindPos).add(0.0, (double)0.2f, 0.0);
        }
        if (pos != null) {
            player.setPos(pos);
        }
        if (pos == null) {
            player.setPos(ox, oy, oz);
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), 1.0f, 1.0f);
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer playerMp = (ServerPlayer)player;
            playerMp.disconnect();
            playerMp.teleportTo(pos.x, pos.y, pos.z);
        }
        player.getCommandSenderWorld().playSound(null, ox, oy, oz, (SoundEvent)ModSounds.TELEPORT_AWAY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.getCommandSenderWorld().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.TELEPORT_HERE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    public int getCooldown(IVampirePlayer iVampirePlayer) {
        return (Integer)CommonConfig.nobleFlankCooldown.get() * 20;
    }

    public boolean canBeUsedBy(IVampirePlayer vampire) {
        return !vampire.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get());
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }
}

