/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions;

import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.networking.ClientboundLeapPacket;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class BloodknightCrimsonLeap
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public boolean isEnabled() {
        return true;
    }

    protected boolean activate(IVampirePlayer iVampirePlayer, IAction.ActivationContext activationContext) {
        int drain;
        int blood = iVampirePlayer.getBloodStats().getBloodLevel();
        if (blood - (drain = ((Integer)CommonConfig.bloodknightCrimsonLeapBloodUse.get()).intValue()) <= 0) {
            iVampirePlayer.asEntity().displayClientMessage((Component)Component.translatable((String)"skill.bloodlines.bloodknight_not_enough_blood").withStyle(ChatFormatting.DARK_RED), true);
            return false;
        }
        iVampirePlayer.useBlood(drain, true);
        Player player = iVampirePlayer.asEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)ClientboundLeapPacket.getInstance(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return true;
    }

    public int getCooldown(IVampirePlayer iVampirePlayer) {
        return (Integer)CommonConfig.bloodknightCrimsonLeapCooldown.get();
    }

    public int getDuration(IVampirePlayer iVampirePlayer) {
        return (Integer)CommonConfig.bloodknightCrimsonLeapDuration.get();
    }

    public void onActivatedClient(IVampirePlayer iVampirePlayer) {
    }

    public void onDeactivated(IVampirePlayer iVampirePlayer) {
    }

    public void onReActivated(IVampirePlayer iVampirePlayer) {
    }

    public boolean onUpdate(IVampirePlayer iVampirePlayer) {
        iVampirePlayer.asEntity().fallDistance = 0.0f;
        if (!iVampirePlayer.asEntity().getCommandSenderWorld().isClientSide) {
            Player player = iVampirePlayer.asEntity();
            ModParticles.spawnParticlesServer((Level)player.getCommandSenderWorld(), (ParticleOptions)new GenericParticleOptions(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"generic_4"), 5, 0x8B0000, 0.1f), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (int)3, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return false;
    }

    public boolean canBeUsedBy(IVampirePlayer player) {
        return !player.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get());
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

