/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions;

import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class BloodknightBloodHunt
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public boolean isEnabled() {
        return true;
    }

    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        int drain;
        int blood = vampire.getBloodStats().getBloodLevel();
        if (blood - (drain = ((Integer)CommonConfig.bloodknightBloodHuntBaseBloodCost.get()).intValue()) <= 0) {
            vampire.asEntity().displayClientMessage((Component)Component.translatable((String)"skill.bloodlines.bloodknight_not_enough_blood").withStyle(ChatFormatting.DARK_RED), true);
            return false;
        }
        vampire.useBlood(drain, true);
        this.activate(vampire);
        return true;
    }

    protected void activate(@NotNull IVampirePlayer player) {
        player.asEntity().setInvisible(true);
    }

    public void onActivatedClient(@NotNull IVampirePlayer vampire) {
        ((VampirePlayer)vampire).getSpecialAttributes().invisible = true;
    }

    public void onDeactivated(@NotNull IVampirePlayer vampire) {
        vampire.asEntity().setInvisible(false);
        ((VampirePlayer)vampire).getSpecialAttributes().invisible = false;
    }

    public void onReActivated(@NotNull IVampirePlayer vampire) {
        this.activate(vampire);
    }

    public boolean onUpdate(IVampirePlayer vampire) {
        if (!vampire.isRemote() && vampire.asEntity().tickCount % (Integer)CommonConfig.bloodknightBloodHuntTimePerBloodLoss.get() == 0) {
            int blood = vampire.getBloodStats().getBloodLevel();
            int drain = 2;
            vampire.useBlood(drain, true);
            if (blood - drain <= 0) {
                vampire.asEntity().displayClientMessage((Component)Component.translatable((String)"skill.bloodlines.bloodknight_not_enough_blood").withStyle(ChatFormatting.DARK_RED), true);
                return true;
            }
        }
        return false;
    }

    public int getCooldown(IVampirePlayer iVampirePlayer) {
        return (Integer)CommonConfig.bloodknightBloodHuntCooldown.get() * 20;
    }

    public int getDuration(IVampirePlayer iVampirePlayer) {
        return (Integer)CommonConfig.bloodknightBloodHuntDuration.get() * 20;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

