/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public enum BloodlineSkillType implements ISkillType
{
    NOBLE(Bloodlines.rl("noble"), "", faction -> faction == VReference.VAMPIRE_FACTION, faction -> true),
    ZEALOT(Bloodlines.rl("zealot"), "", faction -> faction == VReference.VAMPIRE_FACTION, faction -> true),
    ECTOTHERM(Bloodlines.rl("ectotherm"), "", faction -> faction == VReference.VAMPIRE_FACTION, faction -> true),
    BLOODKNIGHT(Bloodlines.rl("bloodknight"), "", faction -> faction == VReference.VAMPIRE_FACTION, faction -> true);

    public final ResourceLocation id;
    public final String nameSuffix;
    public final Predicate<IPlayableFaction<?>> isForFaction;
    public final Predicate<IFactionPlayerHandler> isUnlocked;

    private BloodlineSkillType(ResourceLocation id, String nameSuffix, Predicate<IPlayableFaction<?>> isForFaction, Predicate<IFactionPlayerHandler> isUnlocked) {
        this.id = id;
        this.nameSuffix = nameSuffix;
        this.isForFaction = isForFaction;
        this.isUnlocked = isUnlocked;
    }

    @NotNull
    public ResourceLocation createIdForFaction(@NotNull ResourceLocation id) {
        return Bloodlines.rl(this.id.getPath());
    }

    public boolean isForFaction(@NotNull IPlayableFaction<?> faction) {
        return this.isForFaction.test(faction);
    }

    public ResourceLocation getRegistryName() {
        return this.id;
    }

    public boolean isUnlocked(IFactionPlayerHandler handler) {
        return this.isUnlocked.test(handler);
    }
}

