/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills;

import com.mojang.datafixers.util.Either;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import com.thedrofdoctoring.bloodlines.skills.IBloodlineSkill;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.player.skills.VampirismSkill;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BloodlineSkill<T extends IFactionPlayer<T>>
extends VampirismSkill<T>
implements IBloodlineSkill,
ISkill<T> {
    private final ResourceLocation bloodlineId;
    private Component desc;
    private final int cost;
    private final IBloodline bloodline;
    private final boolean hasCost;

    BloodlineSkill(IBloodline bloodline, boolean desc, int cost) {
        this(bloodline, desc, cost, true);
    }

    @NotNull
    public BloodlineSkill<T> setToggleActions(Consumer<T> activateIn, Consumer<T> deactivateIn) {
        return (BloodlineSkill)super.setToggleActions(activateIn, deactivateIn);
    }

    @NotNull
    public VampirismSkill<T> setHasDefaultDescription() {
        return super.setHasDefaultDescription();
    }

    BloodlineSkill(IBloodline bloodline, boolean desc, int cost, boolean hasCost) {
        super(Either.left(bloodline.getSkillTree()), cost, desc);
        this.bloodline = bloodline;
        this.bloodlineId = bloodline.getBloodlineId();
        this.cost = cost;
        this.hasCost = hasCost;
        BloodlineSkills.addSkill(this, bloodline);
    }

    @NotNull
    public Optional<IPlayableFaction<?>> getFaction() {
        return Optional.of(this.getBloodline().getFaction());
    }

    @Override
    public IBloodline getBloodline() {
        return this.bloodline;
    }

    @Override
    public ResourceLocation getBloodlineId() {
        return this.bloodlineId;
    }

    @Override
    public boolean requiresBloodlineSkillPoints() {
        return this.hasCost;
    }

    public int getSkillPointCost() {
        return this.cost;
    }
}

