/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.networking;

import com.thedrofdoctoring.bloodlines.blocks.SpecialIceBlock;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.IVampSpecialAttributes;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlocks;
import com.thedrofdoctoring.bloodlines.networking.ServerboundIcePacket;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void handleIcePacket(ServerboundIcePacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = context.player().level();
            HitResult result = player.pick(10.0, 1.0f, true);
            if (!(result instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockPos pos = blockResult.getBlockPos();
            if (level.getBlockState(pos).is(Blocks.WATER)) {
                BlockPos[] possiblePositions = new BlockPos[]{new BlockPos(pos.getX(), pos.getY(), pos.getZ() + 1), new BlockPos(pos.getX(), pos.getY(), pos.getZ() - 1), new BlockPos(pos.getX() + 1, pos.getY(), pos.getZ()), new BlockPos(pos.getX() - 1, pos.getY(), pos.getZ())};
                FluidState fState = level.getFluidState(pos);
                BlockState wasSource = (BlockState)((SpecialIceBlock)((Object)((Object)BloodlinesBlocks.ICE_BLOCK.get()))).defaultBlockState().setValue((Property)SpecialIceBlock.WAS_WATER, (Comparable)Boolean.valueOf(true));
                BlockState notSource = (BlockState)((SpecialIceBlock)((Object)((Object)BloodlinesBlocks.ICE_BLOCK.get()))).defaultBlockState().setValue((Property)SpecialIceBlock.WAS_WATER, (Comparable)Boolean.valueOf(false));
                if (((IVampSpecialAttributes)VampirePlayer.get((Player)player).getSpecialAttributes()).bloodlines$getIcePhasing()) {
                    level.setBlock(pos, fState.isSource() ? wasSource : notSource, 3);
                    for (BlockPos possiblePos : possiblePositions) {
                        if (!level.getBlockState(possiblePos).is(Blocks.WATER)) continue;
                        level.setBlock(possiblePos, fState.isSource() ? wasSource : notSource, 3);
                    }
                }
            }
        });
    }
}

