/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.mixin;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineNoble;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineZealot;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Shadow
    public abstract VillagerData getVillagerData();

    @Shadow
    public abstract void playWorkSound();

    public VillagerMixin(EntityType<? extends AbstractVillager> vil, Level level) {
        super(vil, level);
    }

    @Inject(method={"updateSpecialPrices"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;getPlayerReputation(Lnet/minecraft/world/entity/player/Player;)I", shift=At.Shift.BEFORE)})
    private void updateSpecialPrices(Player player, CallbackInfo ci) {
        block3: {
            block5: {
                block4: {
                    if (BuiltInRegistries.VILLAGER_PROFESSION.wrapAsHolder((Object)this.getVillagerData().getProfession()).is(ModTags.Professions.HAS_FACTION) || !Helper.isVampire((Player)player)) break block3;
                    if (!VampirePlayer.get((Player)player).getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.NOBLE_BETTER_TRADE_PRICES.get())) break block4;
                    int rank = BloodlineHelper.getBloodlineRank(player);
                    for (MerchantOffer merchantoffer1 : this.getOffers()) {
                        double rankMult = ((Double)((List)CommonConfig.nobleTradePricesMultiplier.get()).get(rank - 1)).floatValue();
                        int diff = (rankMult = 1.0 - rankMult) != 0.0 ? (int)Math.floor((double)merchantoffer1.getBaseCostA().getCount() * (rankMult - 1.0)) : 0;
                        merchantoffer1.addToSpecialPriceDiff(diff);
                    }
                    break block3;
                }
                if (!(BloodlineManager.get(player).getBloodline() instanceof BloodlineZealot)) break block5;
                int rank = BloodlineHelper.getBloodlineRank(player);
                for (MerchantOffer merchantoffer1 : this.getOffers()) {
                    double rankMult = ((Double)((List)CommonConfig.zealotTradePricesMultiplier.get()).get(rank - 1)).floatValue();
                    int diff = rankMult != 0.0 ? (int)Math.floor((double)merchantoffer1.getBaseCostA().getCount() * (rankMult - 1.0)) : 0;
                    merchantoffer1.addToSpecialPriceDiff(diff);
                }
                break block3;
            }
            if (!(BloodlineManager.get(player).getBloodline() instanceof BloodlineNoble)) break block3;
            int rank = BloodlineHelper.getBloodlineRank(player);
            for (MerchantOffer merchantoffer1 : this.getOffers()) {
                double rankMult = ((Double)((List)CommonConfig.bloodknightTradePricesMultiplier.get()).get(rank - 1)).floatValue();
                int diff = rankMult != 0.0 ? (int)Math.floor((double)merchantoffer1.getBaseCostA().getCount() * (rankMult - 1.0)) : 0;
                merchantoffer1.addToSpecialPriceDiff(diff);
            }
        }
    }
}

