/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.mixin;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesEffects;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.items.VampireBloodBottleItem;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={VampireBloodBottleItem.class})
public class VampireBloodBottleItemMixin
extends Item {
    public VampireBloodBottleItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    public int getUseDuration(@NotNull ItemStack pStack, @NotNull LivingEntity p_344979_) {
        return 25;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        Player player;
        VampirePlayer vp;
        if (entityLiving instanceof Player && (vp = VampirePlayer.get((Player)(player = (Player)entityLiving))).getSkillHandler().isSkillEnabled(BloodlineSkills.BLOODKNIGHT_STILL_BLOOD)) {
            VampirePlayer.get((Player)player).drinkBlood(((Integer)CommonConfig.bloodknightVampireBloodBottleNutrition.get()).intValue(), ((Double)CommonConfig.bloodknightVampireBloodBottleSaturation.get()).floatValue(), (IDrinkBloodContext)new DrinkBloodContext(stack));
            if (((Boolean)CommonConfig.bloodknightStillWaterProvideBuff.get()).booleanValue()) {
                ISkillHandler skillHandler = vp.getSkillHandler();
                int blRank = BloodlineManager.get(player).getRank() - 1;
                int duration = (Integer)((List)CommonConfig.bloodknightBloodFrenzyDurationPerRank.get()).get(blRank) * 20;
                if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_1.get()) && !skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
                    player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 0, false, true, true));
                } else if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
                    player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 1, false, true, true));
                }
            }
            stack.shrink(1);
            player.addItem(Items.GLASS_BOTTLE.getDefaultInstance());
        }
        return stack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player player, @NotNull InteractionHand pUsedHand) {
        ItemStack stack = player.getItemInHand(pUsedHand);
        if (!Helper.isVampire((Player)player)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        VampirePlayer vp = VampirePlayer.get((Player)player);
        if (!vp.getSkillHandler().isSkillEnabled(BloodlineSkills.BLOODKNIGHT_STILL_BLOOD)) {
            player.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.vampire_blood_bottle"), true);
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        player.startUsingItem(pUsedHand);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)pLevel.isClientSide), (Object)stack);
    }
}

