/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.mixin;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesEffects;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import com.thedrofdoctoring.bloodlines.skills.actions.BloodlineActions;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.BatVampireAction;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BatVampireAction.class})
public class BatVampireActionMixin {
    @Inject(method={"setModifier"}, at={@At(value="INVOKE", target="Lde/teamlapen/vampirism/entity/player/vampire/actions/BatVampireAction;setFlightSpeed(Lnet/minecraft/world/entity/player/Player;F)V", shift=At.Shift.AFTER, ordinal=0)}, remap=false)
    private void setNobleBatSpeedMultiplier(Player player, boolean enabled, CallbackInfo ci) {
        VampirePlayer vp = VampirePlayer.get((Player)player);
        if (vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.NOBLE_BAT_FLIGHT_SPEED.get())) {
            int rank = BloodlineHelper.getBloodlineRank(player);
            player.getAbilities().setFlyingSpeed(player.getAbilities().getFlyingSpeed() * ((Double)((List)CommonConfig.nobleBatSpeedMultiplier.get()).get(rank - 1)).floatValue());
        }
        if (vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.NOBLE_BAT_ARMOUR.get())) {
            ResourceLocation key = Objects.requireNonNull(ModRegistries.ACTIONS.getKey((Object)((IAction)VampireActions.BAT.get())));
            BloodlineManager.removeModifier(Objects.requireNonNull(player.getAttribute(Attributes.ARMOR)), key);
            player.getAttribute(Attributes.ARMOR).addPermanentModifier(new AttributeModifier(key, ((Double)CommonConfig.nobleBatArmourMultiplier.get()).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        if (vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_BAT_FRENZY.get()) && (vp.getActionHandler().isActionActive((ILastingAction)BloodlineActions.BLOODKNIGHT_SANGUINE_INFUSION.get()) || player.getEffect(BloodlinesEffects.BLOOD_FRENZY) != null)) {
            player.getAbilities().setFlyingSpeed(player.getAbilities().getFlyingSpeed() * ((Double)CommonConfig.bloodknightBatSpeedMultiplier.get()).floatValue());
        }
    }
}

