/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.items;

import com.thedrofdoctoring.bloodlines.core.BloodlineComponents;
import com.thedrofdoctoring.bloodlines.core.BloodlinesItems;
import com.thedrofdoctoring.bloodlines.items.attachments.ChaliceBlood;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.proxy.ClientProxy;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class BottomlessChaliceItem
extends Item {
    public static final int AMOUNT = 250;
    private static final int MULTIPLIER = 100;
    public static final int CAPACITY = 25000;

    public BottomlessChaliceItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public static ItemStack getStackDamage(int damage) {
        ItemStack stack = new ItemStack((ItemLike)BloodlinesItems.CHALICE_ITEM.get());
        stack.set(BloodlineComponents.CHALICE_BLOOD, (Object)new ChaliceBlood(damage));
        return stack;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean doesSneakBypassUse(ItemStack stack, @NotNull LevelReader world, @NotNull BlockPos pos, Player player) {
        if (world instanceof Level) {
            Level level = (Level)world;
            return level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null) != null;
        }
        return false;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        if (entityLiving instanceof IVampire) {
            ItemStack copy = stack.copy();
            int blood = BloodHelper.getBlood((ItemStack)stack);
            int drink = Math.min(blood, 100);
            ItemStack[] result = new ItemStack[1];
            int amt = BloodHelper.drain((ItemStack)stack, (int)drink, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.EXECUTE, (boolean)true, containerStack -> {
                result[0] = containerStack;
            });
            ((IVampire)entityLiving).drinkBlood(amt / 100, 0.0f, (IDrinkBloodContext)new DrinkBloodContext(copy));
            return result[0];
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).map(IFluidHandlerItem::getContainer).orElseGet(() -> super.finishUsingItem(stack, worldIn, entityLiving));
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 15;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltips, flag);
        Player player = ClientProxy.get().getClientPlayer();
        int blood = ((ChaliceBlood)stack.getOrDefault((DataComponentType)BloodlineComponents.CHALICE_BLOOD.get(), (Object)ChaliceBlood.EMPTY)).blood();
        if (player != null && Helper.isVampire((Player)player)) {
            if (!VampirePlayer.getOpt((Player)player).map(vp -> vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.NOBLE_CHALICE_SKILL.get())).orElse(false).booleanValue()) {
                tooltips.add((Component)Component.translatable((String)"text.bloodlines.chalice").withStyle(ChatFormatting.DARK_PURPLE));
            } else {
                tooltips.add((Component)Component.translatable((String)"text.bloodlines.chalice_blood", (Object[])new Object[]{blood * 100}).withStyle(ChatFormatting.DARK_RED));
            }
        }
    }

    public void bloodUpdated(int newAmount, ItemStack stack) {
        float percentage = (float)newAmount / 250.0f;
        if (newAmount == 0) {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0));
        } else if (newAmount > 1 && percentage <= 0.25f) {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
        } else if (percentage > 0.25f && percentage <= 0.5f) {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(2));
        } else if (percentage > 0.5f) {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(3));
        }
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack stack, int count) {
        if (pLivingEntity instanceof IVampire) {
            return;
        }
        if (!(pLivingEntity instanceof Player) || !pLivingEntity.isAlive()) {
            pLivingEntity.releaseUsingItem();
            return;
        }
        ItemStack copy = stack.copy();
        int blood = BloodHelper.getBlood((ItemStack)stack);
        VampirePlayer vampire = VampirePlayer.getOpt((Player)((Player)pLivingEntity)).orElse(null);
        if (vampire == null || vampire.getLevel() == 0 || blood == 0 || !vampire.getBloodStats().needsBlood()) {
            pLivingEntity.releaseUsingItem();
            return;
        }
        if (!vampire.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.NOBLE_CHALICE_SKILL.get())) {
            pLivingEntity.releaseUsingItem();
            return;
        }
        if (blood > 0 && count == 1) {
            InteractionHand activeHand = pLivingEntity.getUsedItemHand();
            int drink = Math.min(blood, 300);
            if (BloodHelper.drain((ItemStack)stack, (int)drink, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.EXECUTE, (boolean)true, containerStack -> pLivingEntity.setItemInHand(activeHand, containerStack)) > 0) {
                vampire.drinkBlood(Math.round((float)drink / 100.0f), 0.45f, false, (IDrinkBloodContext)new DrinkBloodContext(copy));
            }
            if ((blood = BloodHelper.getBlood((ItemStack)stack)) > 0) {
                pLivingEntity.startUsingItem(pLivingEntity.getUsedItemHand());
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        return VampirePlayer.getOpt((Player)playerIn).map(vampire -> {
            if (vampire.getLevel() == 0) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            if (!vampire.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.NOBLE_CHALICE_SKILL.get())) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            if (vampire.getBloodStats().needsBlood() && stack.getCount() == 1 && BloodHelper.getBlood((ItemStack)stack) != 0) {
                playerIn.startUsingItem(handIn);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            if (BloodHelper.getBlood((ItemStack)stack) == 0) {
                playerIn.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.chalice_out_of_blood"), true);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }).orElse(new InteractionResultHolder(InteractionResult.PASS, (Object)stack));
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return false;
    }
}

