/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.items;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BloodlineFang
extends Item {
    ResourceLocation bloodlineId;

    public BloodlineFang(Item.Properties props, ResourceLocation bloodlineId) {
        super(props);
        this.bloodlineId = bloodlineId;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        IBloodline bloodline = BloodlineHelper.getBloodlineById(this.bloodlineId);
        if (bloodline != null && Helper.isVampire((Player)player)) {
            BloodlineManager.getOpt(player).ifPresent(bl -> {
                if (bl.getBloodline() != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.bloodline_active"), true);
                } else {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.ENTITY_VAMPIRE_SCREAM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.PLAYERS, 1.0f, 1.0f);
                    bl.setRank(1);
                    bl.setBloodline(bloodline);
                    bl.onBloodlineChange(null, 0);
                    String bloodlineName = bloodline.getName();
                    player.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.new_bloodline", (Object[])new Object[]{bloodlineName}).withStyle(ChatFormatting.DARK_RED), true);
                    player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 80, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, 3));
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 90, 2));
                    player.getItemInHand(hand).shrink(1);
                }
            });
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }
}

