/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.entity.BloodlineMobManager;
import com.thedrofdoctoring.bloodlines.commands.BloodlineArgument;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.IFactionMob;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class BloodlineSummonCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.summon.failed"));
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.summon.invalidPosition"));
    private static final SimpleCommandExceptionType INVALID_BLOODLINE = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.bloodline_summon.invalid_bloodline"));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext buildContext) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"summon_bloodline_mob").requires(context -> context.hasPermission(2))).then(Commands.argument((String)"bloodline", (ArgumentType)BloodlineArgument.bloodlines()).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, (ResourceKey)Registries.ENTITY_TYPE)).executes(context -> BloodlineSummonCommand.spawnEntity((CommandSourceStack)context.getSource(), BloodlineArgument.getBloodline((CommandContext<CommandSourceStack>)context, "bloodline"), 1, ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"entity"), ((CommandSourceStack)context.getSource()).getPosition()))).then(((RequiredArgumentBuilder)Commands.argument((String)"rank", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4)).executes(context -> BloodlineSummonCommand.spawnEntity((CommandSourceStack)context.getSource(), BloodlineArgument.getBloodline((CommandContext<CommandSourceStack>)context, "bloodline"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rank"), ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"entity"), ((CommandSourceStack)context.getSource()).getPosition()))).then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).executes(context -> BloodlineSummonCommand.spawnEntity((CommandSourceStack)context.getSource(), BloodlineArgument.getBloodline((CommandContext<CommandSourceStack>)context, "bloodline"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rank"), ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"entity"), Vec3Argument.getVec3((CommandContext)context, (String)"pos")))))));
    }

    public static Entity createEntity(CommandSourceStack pSource, IBloodline bloodline, int rank, Holder.Reference<EntityType<?>> pType, Vec3 pPos) throws CommandSyntaxException {
        BlockPos blockpos = BlockPos.containing((Position)pPos);
        if (!Level.isInSpawnableBounds((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putString("id", pType.key().location().toString());
        ServerLevel serverlevel = pSource.getLevel();
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)serverlevel, p_138828_ -> {
            p_138828_.moveTo(pPos.x, pPos.y, pPos.z, p_138828_.getYRot(), p_138828_.getXRot());
            return p_138828_;
        });
        if (!(entity instanceof PathfinderMob)) {
            throw INVALID_BLOODLINE.create();
        }
        PathfinderMob mob = (PathfinderMob)entity;
        mob.finalizeSpawn((ServerLevelAccessor)pSource.getLevel(), pSource.getLevel().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.COMMAND, null);
        if (mob instanceof IFactionMob) {
            IFactionMob fMob = (IFactionMob)mob;
            if (!bloodline.getFaction().equals((Object)fMob.getFaction())) {
                throw INVALID_BLOODLINE.create();
            }
        } else {
            throw INVALID_BLOODLINE.create();
        }
        BloodlineMobManager manager = BloodlineMobManager.get(mob);
        manager.setBloodline(bloodline);
        manager.setRank(rank);
        manager.onBloodlineChange(null, 0);
        if (!serverlevel.tryAddFreshEntityWithPassengers(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        return entity;
    }

    private static int spawnEntity(CommandSourceStack pSource, IBloodline bloodline, int rank, Holder.Reference<EntityType<?>> pType, Vec3 pPos) throws CommandSyntaxException {
        Entity entity = BloodlineSummonCommand.createEntity(pSource, bloodline, rank, pType, pPos);
        pSource.sendSuccess(() -> Component.translatable((String)"commands.summon.success", (Object[])new Object[]{entity.getDisplayName()}), true);
        return 1;
    }
}

