/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BloodlineArgument
implements ArgumentType<IBloodline> {
    private static final Collection<String> EXAMPLES = BloodlineRegistry.BLOODLINE_REGISTRY.entrySet().stream().map(p -> ((ResourceKey)p.getKey()).location().toString()).toList();
    private static final DynamicCommandExceptionType BLOODLINE_NOT_FOUND = new DynamicCommandExceptionType(id -> Component.translatable((String)"command.bloodlines.argument.bloodline_not_found", (Object[])new Object[]{id}));

    public IBloodline parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.read((StringReader)reader);
        IBloodline bloodline = BloodlineHelper.getBloodlineById(id);
        if (bloodline == null) {
            throw BLOODLINE_NOT_FOUND.create((Object)id);
        }
        return bloodline;
    }

    public static BloodlineArgument bloodlines() {
        return new BloodlineArgument();
    }

    public static IBloodline getBloodline(@NotNull CommandContext<CommandSourceStack> context, String id) {
        return (IBloodline)context.getArgument(id, IBloodline.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(this.getExamples().stream(), (SuggestionsBuilder)builder);
    }
}

