/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.client;

import com.mojang.blaze3d.shaders.FogShape;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.IVampSpecialAttributes;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.mixin.ScreenAccessor;
import de.teamlapen.vampirism.client.gui.screens.VampirismContainerScreen;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventHandler {
    private int bloodlineRank;
    private String bloodlineName;
    private final Minecraft mc;
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"vampirism", (String)"skills_screen/node");

    public ClientEventHandler(@NotNull Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void screenInitEvent(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof VampirismContainerScreen) {
            if (this.mc.player == null) {
                return;
            }
            BloodlineManager bl = BloodlineManager.get((Player)this.mc.player);
            if (bl.getBloodline() != null) {
                this.bloodlineRank = bl.getRank();
                this.bloodlineName = bl.getBloodline().getName();
            } else {
                this.bloodlineRank = 0;
                this.bloodlineName = null;
            }
        }
    }

    @SubscribeEvent
    public void screenRenderEvent(ContainerScreenEvent.Render.Foreground event) {
        AbstractContainerScreen abstractContainerScreen = event.getContainerScreen();
        if (abstractContainerScreen instanceof VampirismContainerScreen) {
            VampirismContainerScreen vampScreen = (VampirismContainerScreen)abstractContainerScreen;
            if (this.bloodlineName != null) {
                String blRank = "(" + this.bloodlineRank + ")";
                GuiGraphics graphics = event.getGuiGraphics();
                Font font = ((ScreenAccessor)vampScreen).getFont();
                float x = 53.0f;
                float y = -8.0f;
                graphics.blitSprite(BACKGROUND, 50, -11, 140, 13);
                graphics.drawString(font, this.bloodlineName, x, y, 0x800000, false);
                graphics.drawString(font, blRank, 173.0f, y, 0x800000, false);
            }
        }
    }

    @SubscribeEvent
    public void gameRenderEvent(ViewportEvent.RenderFog event) {
        if (this.mc.player != null) {
            boolean inWall = ((IVampSpecialAttributes)VampirePlayer.get((Player)this.mc.player).getSpecialAttributes()).bloodlines$isInWall();
            if (inWall) {
                event.setCanceled(true);
                event.setFogShape(FogShape.SPHERE);
                event.setNearPlaneDistance(0.1f);
                event.setFarPlaneDistance(10.0f);
            }
            if (BloodlineManager.get((Player)this.mc.player).getBloodline() == BloodlineRegistry.BLOODLINE_ECTOTHERM.get() && !inWall) {
                int rank = BloodlineHelper.getBloodlineRank((Player)this.mc.player) - 1;
                int viewDist = (Integer)((List)CommonConfig.ectothermUnderwaterVisionDistance.get()).get(rank);
                if (viewDist > 0) {
                    event.setCanceled(true);
                    event.setFarPlaneDistance((float)viewDist);
                }
            }
        }
    }
}

