/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.BloodlinesClient;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.entity.BloodlineMobManager;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import de.teamlapen.vampirism.entity.VampirismEntity;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.NotNull;

public class BloodlineEntityRenderManager
implements ResourceManagerReloadListener {
    private final Map<IBloodline, ResourceLocation[]> bloodlineToTextures = new HashMap<IBloodline, ResourceLocation[]>();
    private final Minecraft mc;

    public BloodlineEntityRenderManager(Minecraft mc) {
        this.mc = mc;
    }

    /*
     * WARNING - void declaration
     */
    public void onResourceManagerReload(@NotNull ResourceManager __resourceManager) {
        void var7_9;
        this.bloodlineToTextures.clear();
        ResourceManager manager = this.mc.getResourceManager();
        ResourceLocation[] textureJsons = (ResourceLocation[])manager.listResources("bloodline_textures", s -> s.getPath().endsWith(".json")).keySet().toArray(ResourceLocation[]::new);
        ArrayList<JsonObject> jsonObjects = new ArrayList<JsonObject>();
        ResourceLocation[] resourceLocationArray = textureJsons;
        int n = resourceLocationArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            ResourceLocation location = resourceLocationArray[var7_9];
            Optional resource = manager.getResource(location);
            if (resource.isPresent()) {
                try (BufferedReader reader = ((Resource)resource.get()).openAsReader();){
                    jsonObjects.add(JsonParser.parseReader((Reader)reader).getAsJsonObject());
                }
                catch (Exception exception) {
                    Bloodlines.LOGGER.error("Could not read bloodlines entity texture json for {}", (Object)location, (Object)exception);
                }
            }
            ++var7_9;
        }
        HashMap<IBloodline, ArrayList<ResourceLocation>> tempMap = new HashMap<IBloodline, ArrayList<ResourceLocation>>();
        for (JsonObject jsonObject : jsonObjects) {
            ResourceLocation bloodlineRl = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"bloodline"));
            IBloodline bloodline = (IBloodline)BloodlineRegistry.BLOODLINE_REGISTRY.get(bloodlineRl);
            ArrayList<ResourceLocation> currentLocations = (ArrayList<ResourceLocation>)tempMap.get(bloodline);
            JsonArray textures = jsonObject.getAsJsonArray("textures");
            for (int i = 0; i < textures.size(); ++i) {
                ResourceLocation location = ResourceLocation.parse((String)textures.get(i).getAsString().concat(".png"));
                if (currentLocations == null) {
                    currentLocations = new ArrayList<ResourceLocation>();
                    currentLocations.add(location);
                    tempMap.put(bloodline, currentLocations);
                    continue;
                }
                currentLocations.add(location);
            }
        }
        for (Map.Entry entry : tempMap.entrySet()) {
            ResourceLocation[] locationsArray = ((ArrayList)entry.getValue()).toArray(new ResourceLocation[0]);
            this.bloodlineToTextures.put((IBloodline)entry.getKey(), locationsArray);
        }
    }

    public ResourceLocation[] getBloodlineTextures(IBloodline bloodline) {
        return this.bloodlineToTextures.get(bloodline);
    }

    public ResourceLocation getBloodlineTexture(ResourceLocation original, VampirismEntity entity) {
        IBloodline bloodline = BloodlineMobManager.get((PathfinderMob)entity).getBloodline();
        if (bloodline != null) {
            ResourceLocation[] textures = BloodlinesClient.getInstance().getRenderManager().getBloodlineTextures(bloodline);
            if (textures == null || textures.length == 0) {
                return original;
            }
            return textures[entity.getId() % textures.length];
        }
        return original;
    }
}

