/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.other;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.storage.IAttachedSyncable;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampExtendedCreature
extends ExtendedCreature {
    public static final String NBT_KEY = "vamp_extended_creature";
    public static final ResourceLocation VAMP_CREATURE_KEY = Bloodlines.rl("vamp_extended_creature");

    public VampExtendedCreature(PathfinderMob entity) {
        super(entity);
    }

    @NotNull
    public ResourceLocation getAttachedKey() {
        return VAMP_CREATURE_KEY;
    }

    public String nbtKey() {
        return NBT_KEY;
    }

    public void sync() {
        HelperLib.sync((IAttachedSyncable)this, (Entity)this.getEntity(), (boolean)true);
    }

    public int onBite(IVampire biter) {
        if (this.getBlood() <= 0) {
            return 0;
        }
        int blood = this.getBlood();
        int amt = Math.max(1, this.getMaxBlood() / (biter instanceof VampirePlayer ? 6 : 2));
        if (amt >= blood) {
            amt = blood > 1 && biter.isAdvancedBiter() ? blood - 1 : blood;
        }
        this.setBlood(blood -= amt);
        PathfinderMob mob = this.getEntity();
        if (blood == 0) {
            DamageHandler.hurtModded((Entity)mob, ModDamageSources::noBlood, (float)1000.0f);
        }
        this.sync();
        mob.setLastHurtByMob(biter.asEntity());
        if (biter.isAdvancedBiter() && mob.getRandom().nextInt(4) == 0) {
            amt = 2 * amt;
        }
        return amt;
    }

    public void setBlood(int blood) {
        super.setBlood(blood);
    }

    public boolean canBeBitten(IVampire biter) {
        PathfinderMob mob = this.getEntity();
        if (biter instanceof VampirePlayer) {
            VampirePlayer vp = (VampirePlayer)biter;
            Player player = vp.asEntity();
            IBloodline bloodline = BloodlineManager.get(player).getBloodline();
            if (bloodline != BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get()) {
                return false;
            }
            boolean modifiedDuration = vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEIGNED_MERCY.get());
            float percentageHealth = modifiedDuration ? ((Double)CommonConfig.bloodknightFeignedVampireMaxHealthFeedingAmount.get()).floatValue() : ((Double)CommonConfig.bloodknightVampireMinHealthFeedingPercentage.get()).floatValue();
            return mob.getHealth() / mob.getMaxHealth() <= percentageHealth;
        }
        return false;
    }

    public boolean canBeInfected(IVampire vampire) {
        return false;
    }

    public void setPoisonousBlood(boolean poisonous) {
    }

    public boolean hasPoisonousBlood() {
        return false;
    }

    public boolean canBecomeVampire() {
        return false;
    }

    @Nullable
    public IConvertedCreature<?> makeVampire() {
        return null;
    }

    public static class Factory
    implements Function<IAttachmentHolder, ExtendedCreature> {
        @Override
        public ExtendedCreature apply(IAttachmentHolder holder) {
            if (holder instanceof VampireBaseEntity) {
                VampireBaseEntity mob = (VampireBaseEntity)holder;
                return new VampExtendedCreature((PathfinderMob)mob);
            }
            if (holder instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)holder;
                return new ExtendedCreature(mob);
            }
            throw new IllegalArgumentException("Cannot create extended creature handler attachment for holder " + String.valueOf(holder.getClass()) + ". Expected PathfinderMob}");
        }
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, ExtendedCreature> {
        @NotNull
        public ExtendedCreature read(@NotNull IAttachmentHolder holder, @NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (holder instanceof VampireBaseEntity) {
                VampireBaseEntity mob = (VampireBaseEntity)holder;
                VampExtendedCreature creature = new VampExtendedCreature((PathfinderMob)mob);
                creature.deserializeNBT(provider, tag);
                return creature;
            }
            if (holder instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)holder;
                ExtendedCreature creature = new ExtendedCreature(mob);
                creature.deserializeNBT(provider, tag);
                return creature;
            }
            throw new IllegalArgumentException("Expected PathfinderMob, got " + holder.getClass().getSimpleName());
        }

        public CompoundTag write(ExtendedCreature attachment, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    }
}

