/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.IVampSpecialAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.VampireBloodline;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.ModConfigSpec;

public class BloodlineZealot
extends VampireBloodline {
    public static final ResourceLocation ZEALOT = Bloodlines.rl("zealot");

    @Override
    public Map<Holder<Attribute>, AttributeModifier> getBloodlineAttributes(int rank, LivingEntity entity, boolean cleanup) {
        int realRank = rank - 1;
        HashMap<Holder<Attribute>, AttributeModifier> attributes = new HashMap<Holder<Attribute>, AttributeModifier>();
        attributes.put((Holder<Attribute>)ModAttributes.SUNDAMAGE, new AttributeModifier(Bloodlines.rl("zealot_sun_damage"), ((Double)((List)CommonConfig.zealotSunDamageMultiplier.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        attributes.put((Holder<Attribute>)ModAttributes.BLOOD_EXHAUSTION, new AttributeModifier(Bloodlines.rl("zealot_exhaustion_decrease"), ((Double)((List)CommonConfig.zealotBloodExhaustionChange.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.updateSpeed(player, realRank);
            ISkillHandler<IVampirePlayer> skillHandler = this.getSkillHandler(player);
            this.applyConditionalModifier(attributes, (ISkill)BloodlineSkills.ZEALOT_SWIFT_SNEAK.get(), (Holder<Attribute>)Attributes.SNEAKING_SPEED, new AttributeModifier(Bloodlines.rl("zealot_serpent_speed"), ((Double)((List)CommonConfig.zealotSerpentSpeedMultipliers.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE), skillHandler, cleanup);
        } else {
            attributes.put(Attributes.ATTACK_DAMAGE, new AttributeModifier(Bloodlines.rl("zealot_mob_damage_increase"), ((Double)((List)CommonConfig.zealotMobDamageIncrease.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        }
        return attributes;
    }

    @Override
    public void onBloodlineChange(LivingEntity entity, int rank) {
        super.onBloodlineChange(entity, rank);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.updateSpeed(player, Math.max(rank - 1, 0));
            if (Helper.isVampire((Player)player)) {
                IVampSpecialAttributes specialAttributes = (IVampSpecialAttributes)VampirePlayer.get((Player)player).getSpecialAttributes();
                specialAttributes.bloodlines$setStoneRunSpeed(1.0f);
            }
        }
    }

    private void updateSpeed(Player player, int rank) {
        float speed = ((Double)((List)CommonConfig.zealotStoneSpeedMultiplier.get()).get(rank)).floatValue();
        IVampSpecialAttributes specialAttributes = (IVampSpecialAttributes)VampirePlayer.get((Player)player).getSpecialAttributes();
        specialAttributes.bloodlines$setStoneRunSpeed(speed);
    }

    @Override
    public ResourceLocation getBloodlineId() {
        return ZEALOT;
    }

    @Override
    public ResourceKey<ISkillTree> getSkillTree() {
        return BloodlineSkills.Trees.ZEALOT;
    }

    @Override
    public ModConfigSpec.ConfigValue<List<? extends String>>[] getDefaultEnabledSkills() {
        return CommonConfig.zealotDefaults;
    }

    @Override
    public String getName() {
        return "Zealot";
    }
}

