/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.VampireBloodline;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForgeMod;

public class BloodlineFrost
extends VampireBloodline {
    public static final ResourceLocation ECTOTHERM = Bloodlines.rl("ectotherm");

    @Override
    public Map<Holder<Attribute>, AttributeModifier> getBloodlineAttributes(int rank, LivingEntity entity, boolean cleanup) {
        int realRank = rank - 1;
        HashMap<Holder<Attribute>, AttributeModifier> attributes = new HashMap<Holder<Attribute>, AttributeModifier>();
        double speedMul = 1.0;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ISkillHandler<IVampirePlayer> skillHandler = this.getSkillHandler(player);
            this.applyConditionalModifier(attributes, (ISkill)BloodlineSkills.ECTOTHERM_MINING_SPEED_UNDERWATER.get(), (Holder<Attribute>)Attributes.SUBMERGED_MINING_SPEED, new AttributeModifier(Bloodlines.rl("ectotherm_underwater_mining_speed"), ((Double)((List)CommonConfig.ectothermUnderwaterMiningSpeedMultiplier.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), skillHandler, cleanup);
            this.applyConditionalModifier(attributes, (ISkill)BloodlineSkills.ECTOTHERM_TENTACLES.get(), (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(Bloodlines.rl("ectotherm_tentacles"), ((Double)CommonConfig.ectothermTentacleInteractionDistance.get()).doubleValue(), AttributeModifier.Operation.ADD_VALUE), skillHandler, cleanup);
            speedMul = skillHandler.isSkillEnabled((ISkill)BloodlineSkills.ECTOTHERM_HYDRODYNAMIC_FORM.get()) ? (Double)CommonConfig.ectothermHydrodynamicFormSpeedMultiplier.get() : 1.0;
        } else {
            attributes.put(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(Bloodlines.rl("ectotherm_knockback_resistance"), ((Double)((List)CommonConfig.ectothermMobAdditionalKnockbackResistance.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        }
        attributes.put((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, new AttributeModifier(Bloodlines.rl("ectotherm_swim_speed"), (Double)((List)CommonConfig.ectothermSwimSpeedMultipliers.get()).get(realRank) * speedMul, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return attributes;
    }

    @Override
    public ResourceLocation getBloodlineId() {
        return ECTOTHERM;
    }

    @Override
    public ResourceKey<ISkillTree> getSkillTree() {
        return BloodlineSkills.Trees.ECTOTHERM;
    }

    @Override
    public ModConfigSpec.ConfigValue<List<? extends String>>[] getDefaultEnabledSkills() {
        return CommonConfig.ectothermDefaults;
    }

    @Override
    public String getName() {
        return "Ectotherm";
    }
}

