/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines.entity;

import com.mojang.datafixers.util.Pair;
import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.entity.BloodlineMobManager;
import com.thedrofdoctoring.bloodlines.data.BloodlineSelector;
import com.thedrofdoctoring.bloodlines.data.BloodlinesData;
import com.thedrofdoctoring.bloodlines.data.spawn_modifiers.BloodlineRankDistribution;
import com.thedrofdoctoring.bloodlines.data.spawn_modifiers.BloodlineSpawnModifier;
import de.teamlapen.vampirism.entity.VampirismEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="bloodlines")
public class BloodlineEntityEventHandler {
    @SubscribeEvent
    public static void entityJoinWorldEvent(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof VampirismEntity) {
            VampirismEntity entity2 = (VampirismEntity)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)entity;
                Optional<BloodlineMobManager> bloodlineMobManager = BloodlineMobManager.getSafe((Entity)entity2);
                if (bloodlineMobManager.isEmpty()) {
                    return;
                }
                BloodlineMobManager mobManager = bloodlineMobManager.get();
                if (mobManager.getBloodline() != null) {
                    BloodlineEntityEventHandler.handleAIGoals(entity2, mobManager.getBloodline(), (Level)level);
                    return;
                }
                Optional optSpawnModifiers = level.registryAccess().registry(BloodlinesData.BLOODLINE_SPAWN_MODIFIERS);
                if (optSpawnModifiers.isEmpty()) {
                    return;
                }
                Registry spawnModifiersRegistry = (Registry)optSpawnModifiers.get();
                ArrayList<WeightedEntry.Wrapper> weightVals = new ArrayList<WeightedEntry.Wrapper>();
                Holder entityBiome = entity2.level().getBiome(entity2.blockPosition());
                for (Map.Entry entries : spawnModifiersRegistry.entrySet()) {
                    BloodlineSpawnModifier modifier = (BloodlineSpawnModifier)entries.getValue();
                    if (!modifier.targetEntities().contains(event.getEntity().getType())) continue;
                    int totalWeight = 0;
                    for (Pair<HolderSet<Biome>, Integer> pairs : modifier.weightPairs()) {
                        if (!((HolderSet)pairs.getFirst()).contains(entityBiome)) continue;
                        totalWeight += ((Integer)pairs.getSecond()).intValue();
                    }
                    if (entity2.blockPosition().getY() <= (Integer)modifier.yLevelWeightPair().getFirst()) {
                        totalWeight += ((Integer)modifier.yLevelWeightPair().getSecond()).intValue();
                    }
                    if (totalWeight < 0) continue;
                    weightVals.add(WeightedEntry.wrap((Object)modifier.bloodline(), (int)totalWeight));
                }
                if (weightVals.isEmpty()) {
                    return;
                }
                IBloodline targetBloodline = WeightedRandom.getRandomItem((RandomSource)level.getRandom(), weightVals).map(WeightedEntry.Wrapper::data).orElse(null);
                if (targetBloodline == null) {
                    return;
                }
                Optional optRankDistributions = level.registryAccess().registry(BloodlinesData.BLOODLINE_RANK_DISTRIBUTION);
                if (optRankDistributions.isEmpty()) {
                    Bloodlines.LOGGER.error("Couldn't access Bloodline Rank Distributions. Mobs will likely not receive bloodlines correctly.");
                    return;
                }
                Registry rankDistributions = (Registry)optRankDistributions.get();
                BloodlineRankDistribution distribution = (BloodlineRankDistribution)rankDistributions.get(targetBloodline.getBloodlineId());
                if (distribution == null) {
                    Bloodlines.LOGGER.error("Bloodline chosen for entity {} but no rank distribution found, how?", (Object)event.getEntity());
                    return;
                }
                List<Float> percentages = distribution.rankDistributions();
                float random = event.getEntity().getRandom().nextFloat();
                double cumulative = 0.0;
                int targetRank = 0;
                for (int i = 0; i < percentages.size(); ++i) {
                    if (!((double)random <= (cumulative += (double)percentages.get(i).floatValue()))) continue;
                    targetRank = i;
                    break;
                }
                mobManager.setBloodline(targetBloodline);
                mobManager.setRank(targetRank);
                mobManager.onBloodlineChange(null, 0);
                BloodlineEntityEventHandler.handleAIGoals(entity2, targetBloodline, (Level)level);
            }
        }
    }

    private static void handleAIGoals(VampirismEntity entity, IBloodline bloodline, Level level) {
        Optional AISelectors = level.registryAccess().registry(BloodlinesData.BLOODLINE_AI_SELECTORS);
        if (AISelectors.isEmpty()) {
            return;
        }
        Registry selectors = (Registry)AISelectors.get();
        BloodlineSelector selector = (BloodlineSelector)selectors.get(bloodline.getBloodlineId());
        if (selector == null) {
            return;
        }
        Predicate<LivingEntity> predicate = BloodlineEntityEventHandler.getLivingEntityPredicate(selector);
        entity.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)entity, LivingEntity.class, true, predicate));
    }

    @NotNull
    private static Predicate<LivingEntity> getLivingEntityPredicate(BloodlineSelector selector) {
        List<IBloodline> enemyBloodlines = selector.targetBloodlines();
        boolean shouldAttackNonBloodlined = selector.targetNoBloodline();
        return entity -> {
            if (entity.isInvisible()) {
                return false;
            }
            if (entity instanceof Player || entity instanceof VampirismEntity && !selector.playerOnly()) {
                Optional<IBloodlineManager> optManager = BloodlineHelper.getBloodlineData(entity);
                if (optManager.isPresent()) {
                    IBloodlineManager manager = optManager.get();
                    return enemyBloodlines.contains(manager.getBloodline());
                }
                return shouldAttackNonBloodlined;
            }
            return false;
        };
    }
}

