/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public interface IBloodline {
    public static final Codec<IBloodline> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(IBloodline::getBloodlineId)).apply((Applicative)ins, BloodlineHelper::getBloodlineById));

    public Map<Holder<Attribute>, AttributeModifier> getBloodlineAttributes(int var1, LivingEntity var2, boolean var3);

    default public void onBloodlineChange(LivingEntity entity, int rank) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (rank > 0) {
                this.enableDefaultSkills(rank, player);
            }
        }
    }

    public ResourceLocation getBloodlineId();

    public IPlayableFaction<?> getFaction();

    @Nullable
    public ISkillHandler<?> getSkillHandler(Player var1);

    public ResourceKey<ISkillTree> getSkillTree();

    public ModConfigSpec.ConfigValue<List<? extends String>>[] getDefaultEnabledSkills();

    private void enableDefaultSkills(int rank, Player player) {
        if (!player.getCommandSenderWorld().isClientSide) {
            ModConfigSpec.ConfigValue<List<? extends String>>[] defaultSkills = this.getDefaultEnabledSkills();
            ISkillHandler<?> skillHandler = this.getSkillHandler(player);
            for (int i = 0; i < rank; ++i) {
                ((List)defaultSkills[i].get()).forEach(str -> {
                    ResourceLocation skill = ResourceLocation.parse((String)str);
                    ISkill iSkill = RegUtil.getSkill((ResourceLocation)skill);
                    if (RegUtil.getSkill((ResourceLocation)skill) == null || iSkill.getFaction().isEmpty() || iSkill.getFaction().get() != this.getFaction()) {
                        throw new IllegalStateException("Default Bloodline Enabled Skill " + String.valueOf(skill) + " is invalid!");
                    }
                    if (!skillHandler.isSkillEnabled(iSkill)) {
                        skillHandler.enableSkill(iSkill);
                    }
                });
            }
        }
    }

    default public void applyConditionalModifier(Map<Holder<Attribute>, AttributeModifier> attributes, ISkill<?> skill, Holder<Attribute> attribute, AttributeModifier modifier, ISkillHandler<?> skillHandler, boolean cleanup) {
        if (skillHandler.isSkillEnabled(skill) || cleanup) {
            attributes.put(attribute, modifier);
        }
    }

    public String getName();
}

