/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines;

import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class BloodlineSkillHandler {
    private int skillPoints;
    private int enabledSkills;
    private final Map<ResourceLocation, Integer> rewardMap = new HashMap<ResourceLocation, Integer>();

    public void deserializeNBT(CompoundTag nbt) {
        this.skillPoints = nbt.getInt("blSkillPoints");
        this.enabledSkills = nbt.getInt("blEnabledSkills");
        this.deserialiseRewardMap(nbt);
    }

    public CompoundTag serializeNBT(CompoundTag nbt) {
        nbt.putInt("blSkillPoints", this.skillPoints);
        nbt.putInt("blEnabledSkills", this.enabledSkills);
        this.serializeRewardMap(nbt);
        return nbt;
    }

    public void deserializeUpdateNBT(CompoundTag nbt) {
        this.skillPoints = nbt.getInt("blSkillPoints");
        this.enabledSkills = nbt.getInt("blEnabledSkills");
        this.deserialiseRewardMap(nbt);
    }

    public CompoundTag serializeUpdateNBT(CompoundTag nbt) {
        nbt.putInt("blSkillPoints", this.skillPoints);
        nbt.putInt("blEnabledSkills", this.enabledSkills);
        this.serializeRewardMap(nbt);
        return nbt;
    }

    public void setEnabledSkills(int enabledSkills) {
        this.enabledSkills = enabledSkills;
    }

    public int getEnabledSkills() {
        return this.enabledSkills;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public void clearSkillPoints() {
        this.skillPoints = 0;
        this.rewardMap.clear();
    }

    public int getRemainingSkillPoints() {
        return Math.max(0, this.skillPoints - this.enabledSkills);
    }

    public void addSkillPoints(ResourceLocation source, int amount) {
        this.skillPoints += amount;
        if (this.rewardMap.containsKey(source)) {
            this.rewardMap.compute(source, (k, totalGained) -> totalGained + amount);
            return;
        }
        this.rewardMap.put(source, amount);
    }

    public void addSkillPoints(int amount) {
        this.skillPoints += amount;
    }

    public int getPointsFromSource(ResourceLocation source) {
        return this.rewardMap.getOrDefault(source, 0);
    }

    private void serializeRewardMap(CompoundTag nbt) {
        for (Map.Entry<ResourceLocation, Integer> entry : this.rewardMap.entrySet()) {
            nbt.putInt(entry.getKey().toString(), entry.getValue().intValue());
        }
    }

    private void deserialiseRewardMap(CompoundTag nbt) {
        for (String key : nbt.getAllKeys()) {
            DataResult location = ResourceLocation.read((String)key);
            if (location.isError()) continue;
            int val = nbt.getInt(key);
            this.rewardMap.put(ResourceLocation.parse((String)key), val);
        }
    }
}

