/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.entity.BloodlineMobManager;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class BloodlineHelper {
    public static int getBloodlineRank(Player player) {
        return BloodlineManager.getOpt(player).map(BloodlineManager::getRank).orElse(0);
    }

    public static IBloodline getBloodlineById(ResourceLocation id) {
        if (BloodlineRegistry.BLOODLINE_REGISTRY.containsKey(id)) {
            return (IBloodline)BloodlineRegistry.BLOODLINE_REGISTRY.get(id);
        }
        return null;
    }

    public static Optional<IBloodlineManager> getBloodlineData(LivingEntity entity) {
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            return BloodlineMobManager.getSafe((Entity)pathfinderMob).filter(blManager -> blManager.getBloodline() != null).map(blManager -> blManager);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BloodlineManager blManager2 = BloodlineManager.get(player);
            return blManager2.getBloodline() != null ? Optional.of(blManager2) : Optional.empty();
        }
        return Optional.empty();
    }

    public static IBloodlineManager getBloodlineManager(LivingEntity entity) {
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            return BloodlineMobManager.get(pathfinderMob);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return BloodlineManager.get(player);
        }
        return null;
    }

    public static boolean lightMatches(int requiredLight, BlockPos pos, Level level, boolean includeShade) {
        int skyLight;
        int blockLight = level.getBrightness(LightLayer.BLOCK, pos);
        int highestLight = Math.max(blockLight, skyLight = level.getBrightness(LightLayer.SKY, pos));
        if (highestLight > requiredLight && !includeShade) {
            return false;
        }
        if (level.isNight() && includeShade && blockLight < requiredLight && skyLight <= 13) {
            return true;
        }
        return highestLight < requiredLight;
    }
}

