/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineBloodknight;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineFrost;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineNoble;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineZealot;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.IVampSpecialAttributes;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesEffects;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.data.BloodlinesTagsProviders;
import com.thedrofdoctoring.bloodlines.entity.ZealotTargetGoalModifier;
import com.thedrofdoctoring.bloodlines.networking.ServerboundIcePacket;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import com.thedrofdoctoring.bloodlines.skills.actions.BloodlineActions;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.event.ActionEvent;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.api.event.PlayerFactionEvent;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModDamageTypes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.InvisibilityVampireAction;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.items.VampirismItemBloodFoodItem;
import de.teamlapen.vampirism.mixin.accessor.GoalSelectorAccessor;
import de.teamlapen.vampirism.mixin.accessor.NearestAttackableTargetGoalAccessor;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.world.LevelFog;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="bloodlines")
public class BloodlineEventHandler {
    private static final ResourceLocation reducedMovementSpeed = Bloodlines.rl("ectotherm_biome_reduced_movement_speed");
    private static final ResourceLocation increasedMovementSpeed = Bloodlines.rl("ectotherm_biome_increased_movement_speed");
    private static final ResourceLocation reducedMaxHealth = Bloodlines.rl("ectotherm_biome_reduced_max_haelth");
    private static final Object2BooleanMap<String> entityAIReplacementWarnMap = new Object2BooleanArrayMap();

    @SubscribeEvent
    public static void onChangeFaction(PlayerFactionEvent.FactionLevelChanged event) {
        if (event.getPlayer().asEntity().getCommandSenderWorld().isClientSide) {
            return;
        }
        if (event.getNewLevel() == 0 || event.getCurrentFaction() != event.getOldFaction() && event.getOldFaction() != null) {
            BloodlineManager.getOpt(event.getPlayer().asEntity()).ifPresent(bl -> {
                IBloodline bloodline = bl.getBloodline();
                int rank = bl.getRank();
                bl.setBloodline(null);
                bl.setRank(0);
                bl.onBloodlineChange(bloodline, rank);
            });
        }
    }

    @SubscribeEvent
    public static void onPotionRemove(MobEffectEvent.Remove event) {
        LivingEntity livingEntity;
        if (event.getEffect() == ModEffects.OBLIVION.get() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            BloodlineManager.getOpt(player).ifPresent(bl -> {
                if (bl.getBloodline() != null) {
                    bl.getBloodline().onBloodlineChange((LivingEntity)player, bl.getRank());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        Player player;
        Player player2 = event.getEntity();
        if (player2 instanceof Player && Helper.isVampire((Player)(player = player2)) && (player2 = event.getTarget()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)player2;
            VampirePlayer vp = VampirePlayer.get((Player)player);
            if (vp.getActionHandler().isActionActive((ILastingAction)BloodlineActions.ECTOTHERM_FROST_LORD_ACTION.get())) {
                if (vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ECTOTHERM_FROZEN_ATTACK.get())) {
                    living.setTicksFrozen(((Integer)CommonConfig.ectothermFrozenAttackFreezingAmount.get()).intValue());
                }
                if (vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ECTOTHERM_SLOWNESS_ATTACK.get())) {
                    living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, ((Integer)CommonConfig.ectothermSlowingAttackSlownessDuration.get()).intValue(), 0));
                }
            }
            if (!event.getTarget().getType().is(EntityTypeTags.UNDEAD) && vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_POISONED_STRIKE.get())) {
                living.addEffect(new MobEffectInstance(MobEffects.POISON, ((Integer)CommonConfig.zealotPoisonedStrikeDuration.get()).intValue(), 0));
            }
        }
    }

    @SubscribeEvent
    public static void onBloodDrink(BloodDrinkEvent.PlayerDrinkBloodEvent event) {
        IVampire iVampire = event.getVampire();
        if (iVampire instanceof VampirePlayer) {
            VampirePlayer vp = (VampirePlayer)iVampire;
            BloodlineManager.getOpt(vp.getRepresentingPlayer()).ifPresent(bl -> {
                int rank = bl.getRank() - 1;
                if (bl.getBloodline() instanceof BloodlineNoble) {
                    if (event.getBloodSource().getStack().isPresent() && ((ItemStack)event.getBloodSource().getStack().get()).getItem() instanceof VampirismItemBloodFoodItem) {
                        event.setAmount((int)((float)event.getAmount() * ((Double)((List)CommonConfig.nobleBloodGainDecreaseMultiplier.get()).get(rank)).floatValue()));
                        event.setSaturationModifier(event.getSaturation() * ((Double)((List)CommonConfig.nobleBloodGainDecreaseMultiplier.get()).get(rank)).floatValue());
                    } else if (event.getBloodSource().getEntity().isPresent() && vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.NOBLE_BETTER_BLOOD_DRAIN.get())) {
                        event.setAmount((int)((float)event.getAmount() * ((Double)((List)CommonConfig.nobleBloodGainMultiplier.get()).get(rank)).floatValue()));
                        event.setSaturationModifier(event.getSaturation() * ((Double)((List)CommonConfig.nobleBloodGainMultiplier.get()).get(rank)).floatValue());
                    }
                }
                if (bl.getBloodline() instanceof BloodlineBloodknight) {
                    List<Item> allowed;
                    if (event.getBloodSource().getStack().isPresent() && !(allowed = List.of((Item)ModItems.VAMPIRE_BLOOD_BOTTLE.get(), (Item)ModItems.BLOOD_BOTTLE.get())).contains(((ItemStack)event.getBloodSource().getStack().get()).getItem())) {
                        event.setAmount((int)((float)event.getAmount() * ((Double)((List)CommonConfig.bloodknightOtherSourceBloodDecrease.get()).get(rank)).floatValue()));
                        event.setSaturationModifier(event.getSaturation() * ((Double)((List)CommonConfig.bloodknightOtherSourceBloodDecrease.get()).get(rank)).floatValue());
                    }
                    if (event.getBloodSource().getEntity().isPresent()) {
                        LivingEntity entity = (LivingEntity)event.getBloodSource().getEntity().get();
                        if (!Helper.isVampire((Entity)entity)) {
                            event.setAmount((int)((float)event.getAmount() * ((Double)((List)CommonConfig.bloodknightOtherSourceBloodDecrease.get()).get(rank)).floatValue()));
                            event.setSaturationModifier(event.getSaturation() * ((Double)((List)CommonConfig.bloodknightOtherSourceBloodDecrease.get()).get(rank)).floatValue());
                        } else {
                            ISkillHandler skillHandler = vp.getSkillHandler();
                            Player player = vp.asEntity();
                            int duration = (Integer)((List)CommonConfig.bloodknightBloodFrenzyDurationPerRank.get()).get(rank) * 20;
                            if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_1.get()) && !skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
                                player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 0, false, true, true));
                            } else if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
                                player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 1, false, true, true));
                            }
                            if (!(entity instanceof Player)) {
                                event.setAmount((int)((float)event.getAmount() * ((Double)((List)CommonConfig.bloodknightVampireBonusBloodMult.get()).get(rank)).floatValue()));
                                event.setSaturationModifier(event.getSaturation() * ((Double)((List)CommonConfig.bloodknightVampireBonusSaturationMult.get()).get(rank)).floatValue());
                            }
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onCrit(CriticalHitEvent event) {
        if (event.isVanillaCritical()) {
            LivingEntity living;
            Entity living2;
            VampirePlayer vp = VampirePlayer.get((Player)event.getEntity());
            if (vp.asEntity().isCrouching() && vp.getSkillHandler().isSkillEnabled(BloodlineSkills.BLOODKNIGHT_HIDDEN_STRIKE) && vp.getActionHandler().isActionActive((ILastingAction)BloodlineActions.BLOODKNIGHT_BLOOD_HUNT.get())) {
                Entity entity = event.getTarget();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    int slownessDuration = (Integer)CommonConfig.bloodknightHiddenStrikeSlownessDurationPlayer.get();
                    weaknessDuration = (Integer)CommonConfig.bloodknightHiddenStrikeWeaknessDurationPlayer.get();
                    player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, weaknessDuration, 0));
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, slownessDuration, 0));
                } else {
                    Entity slownessDuration = event.getTarget();
                    if (slownessDuration instanceof LivingEntity) {
                        living2 = (LivingEntity)slownessDuration;
                        int slownessDuration2 = (Integer)CommonConfig.bloodknightHiddenStrikeSlownessDurationMob.get();
                        weaknessDuration = (Integer)CommonConfig.bloodknightHiddenStrikeWeaknessDurationMob.get();
                        living2.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, weaknessDuration, 0));
                        living2.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, slownessDuration2, 0));
                    }
                }
                vp.getActionHandler().deactivateAction((ILastingAction)BloodlineActions.BLOODKNIGHT_BLOOD_HUNT.get());
            }
            if (vp.getSkillHandler().isSkillEnabled(BloodlineSkills.BLOODKNIGHT_SAPPING_STRIKE) && (living2 = event.getTarget()) instanceof LivingEntity && Helper.isVampire((Entity)(living = (LivingEntity)living2))) {
                float saturation = ((Double)CommonConfig.bloodknightSappingStrikeSaturation.get()).floatValue();
                DrinkBloodContext emptyCon = new DrinkBloodContext(null, null);
                if (living instanceof Player) {
                    Player player = (Player)living;
                    VampirePlayer targetVP = VampirePlayer.get((Player)player);
                    int amt = (Integer)CommonConfig.bloodknightSappingStrikePlayerDrain.get();
                    targetVP.useBlood(amt, true);
                    vp.drinkBlood(amt, saturation, (IDrinkBloodContext)emptyCon);
                    BloodlineEventHandler.addFrenzy(vp);
                } else {
                    @NotNull Optional c = ExtendedCreature.getSafe((Entity)living);
                    if (c.isPresent()) {
                        ExtendedCreature creature = (ExtendedCreature)c.get();
                        int amt = (Integer)CommonConfig.bloodknightSappingStrikeMobDrain.get();
                        creature.setBlood(creature.getBlood() - amt);
                        vp.drinkBlood(amt, saturation, (IDrinkBloodContext)emptyCon);
                        BloodlineEventHandler.addFrenzy(vp);
                    }
                }
            }
        }
    }

    private static void addFrenzy(VampirePlayer vp) {
        ISkillHandler skillHandler = vp.getSkillHandler();
        Player player = vp.asEntity();
        int duration = 600;
        if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_1.get()) && !skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
            player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 0, false, true, true));
        } else if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
            player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 1, false, true, true));
        }
    }

    @SubscribeEvent
    public static void onTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.tickCount % 5 == 0 && BloodlineManager.get(player).getBloodline() instanceof BloodlineFrost) {
            player.setTicksFrozen(0);
        }
        if (player.tickCount % 10 == 0) {
            BloodlineEventHandler.checkNobleRain(player);
            BloodlineEventHandler.checkEctothermBiome(player);
        }
    }

    private static void checkNobleRain(Player player) {
        if (player.isSpectator() || !Helper.isVampire((Player)player) || VampirePlayer.getOpt((Player)player).map(vp -> vp.getSpecialAttributes().waterResistance).orElse(false).booleanValue()) {
            return;
        }
        BlockPos pos = player.getOnPos();
        if (((Biome)player.level().getBiome(pos).value()).getPrecipitationAt(pos) != Biome.Precipitation.RAIN || !player.level().isRaining()) {
            return;
        }
        BlockPos realPos = new BlockPos((int)player.getX(), (int)(player.getY() + (double)Mth.clamp((float)(player.getBbHeight() / 2.0f), (float)0.0f, (float)2.0f)), (int)player.getZ());
        if (Helper.canBlockSeeSun((LevelAccessor)player.level(), (BlockPos)realPos) && !LevelFog.getOpt((Level)player.level()).map(vw -> vw.isInsideArtificialVampireFogArea(new BlockPos((int)player.getX(), (int)(player.getY() + 1.0), (int)player.getZ()))).orElse(false).booleanValue() && ((Boolean)CommonConfig.nobleRainWeakness.get()).booleanValue() && VampirePlayer.getOpt((Player)player).map(vp -> vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.NOBLE_RANK_3.get())).orElse(false).booleanValue()) {
            player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 40, 1));
        }
    }

    private static void checkEctothermBiome(Player player) {
        if (BloodlineManager.get(player).getBloodline() instanceof BloodlineFrost && !player.level().isClientSide) {
            int rank = BloodlineManager.get(player).getRank() - 1;
            int modifierRank = rank + 1;
            Holder biome = player.level().getBiome(player.getOnPos());
            if (biome.is(Tags.Biomes.IS_HOT) && biome.is(Tags.Biomes.IS_OCEAN)) {
                if (modifierRank >= (Integer)CommonConfig.ectothermHotBiomeReducedMaxHealthRank.get() && !BloodlineEventHandler.hasAttributeAlready(player, (Holder<Attribute>)Attributes.MAX_HEALTH, reducedMaxHealth)) {
                    player.getAttribute(Attributes.MAX_HEALTH).addPermanentModifier(new AttributeModifier(reducedMaxHealth, ((Double)((List)CommonConfig.ectothermHotBiomeReducedMaxHealthAmount.get()).get(rank)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
                }
                if (modifierRank >= (Integer)CommonConfig.ectothermHotBiomeReducedMovementSpeedRank.get() && !BloodlineEventHandler.hasAttributeAlready(player, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, reducedMovementSpeed)) {
                    player.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(reducedMovementSpeed, ((Double)((List)CommonConfig.ectothermHotBiomeReducedMovementSpeedMultiplier.get()).get(rank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                }
            } else {
                BloodlineManager.removeModifier(player.getAttribute(Attributes.MOVEMENT_SPEED), reducedMovementSpeed);
                BloodlineManager.removeModifier(player.getAttribute(Attributes.MAX_HEALTH), reducedMaxHealth);
            }
            if (biome.is(Tags.Biomes.IS_COLD)) {
                if (modifierRank >= (Integer)CommonConfig.ectothermColdBiomeIncreasedMovementSpeedRank.get() && !BloodlineEventHandler.hasAttributeAlready(player, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, increasedMovementSpeed)) {
                    player.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(increasedMovementSpeed, ((Double)((List)CommonConfig.ectothermColdBiomeSpeedMultiplier.get()).get(rank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                }
            } else {
                BloodlineManager.removeModifier(player.getAttribute(Attributes.MOVEMENT_SPEED), increasedMovementSpeed);
            }
        } else if (player.tickCount % 50 == 0 && !player.level().isClientSide) {
            BloodlineManager.removeModifier(player.getAttribute(Attributes.MOVEMENT_SPEED), reducedMovementSpeed);
            BloodlineManager.removeModifier(player.getAttribute(Attributes.MAX_HEALTH), reducedMaxHealth);
            BloodlineManager.removeModifier(player.getAttribute(Attributes.MOVEMENT_SPEED), increasedMovementSpeed);
        }
    }

    private static boolean hasAttributeAlready(Player player, Holder<Attribute> att, ResourceLocation rl) {
        return player.getAttribute(att).hasModifier(rl);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDamage(LivingIncomingDamageEvent event) {
        IBloodlineManager bl;
        LivingEntity source;
        if (event.getEntity().getCommandSenderWorld().isClientSide) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity && Helper.isVampire((Entity)(source = (LivingEntity)entity))) {
            if (source instanceof Player) {
                Player player = (Player)source;
                BloodlineEventHandler.handleLeeching(player, event.getAmount(), event.getEntity());
                if (!UtilLib.canReallySee((LivingEntity)event.getEntity(), (LivingEntity)source, (boolean)false) && VampirePlayer.get((Player)player).getSkillHandler().isSkillEnabled(BloodlineSkills.NOBLE_INTRIGUE)) {
                    event.setAmount(event.getAmount() * ((Double)CommonConfig.nobleIntrigueDamageMultiplier.get()).floatValue());
                }
            }
            if (Helper.isVampire((Entity)event.getEntity())) {
                IBloodlineManager sourceBL;
                bl = BloodlineHelper.getBloodlineManager(event.getEntity());
                if (bl != null && bl.getBloodlineId() == BloodlineNoble.NOBLE) {
                    event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.nobleIncreasedNonNobleDamage.get()).get(bl.getRank() - 1)).floatValue());
                }
                if ((sourceBL = BloodlineHelper.getBloodlineManager(source)) != null && sourceBL.getBloodline() == BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get()) {
                    int rank = sourceBL.getRank() - 1;
                    event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.bloodknightVampireDamageMult.get()).get(rank)).floatValue());
                }
            }
        }
        if ((event.getEntity() instanceof Player || event.getEntity() instanceof PathfinderMob) && Helper.isVampire((Entity)event.getEntity())) {
            LivingEntity entity2;
            Entity entity3;
            LivingEntity vampireTarget = event.getEntity();
            bl = BloodlineHelper.getBloodlineManager(vampireTarget);
            if (bl == null) {
                return;
            }
            IVampSpecialAttributes specialAttributes = null;
            ISkillHandler skillHandler = null;
            if (vampireTarget instanceof Player) {
                Player playerVampire = (Player)vampireTarget;
                specialAttributes = (IVampSpecialAttributes)VampirePlayer.get((Player)playerVampire).getSpecialAttributes();
                skillHandler = VampirePlayer.get((Player)playerVampire).getSkillHandler();
            }
            int rank = bl.getRank() - 1;
            if (bl.getBloodline() instanceof BloodlineNoble && (event.getSource().is(ModDamageTypes.VAMPIRE_ON_FIRE) || event.getSource().is(ModDamageTypes.VAMPIRE_IN_FIRE))) {
                event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.nobleFireDamageMultiplier.get()).get(rank)).floatValue());
            }
            if (bl.getBloodline() instanceof BloodlineZealot) {
                int brightness = vampireTarget.getCommandSenderWorld().getRawBrightness(vampireTarget.getOnPos().above(), 0);
                if ((specialAttributes == null || specialAttributes.bloodlines$getShadowArmour()) && brightness <= (Integer)CommonConfig.zealotShadowArmourLightLevel.get()) {
                    event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.zealotShadowArmourDamageMultiplier.get()).get(rank)).floatValue());
                    ModParticles.spawnParticlesServer((Level)vampireTarget.getCommandSenderWorld(), (ParticleOptions)new GenericParticleOptions(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"generic_7"), 40, 0, 0.2f), (double)vampireTarget.getX(), (double)(vampireTarget.getY() + 0.5), (double)vampireTarget.getZ(), (int)10, (double)0.0, (double)0.2f, (double)0.0, (double)0.0);
                }
                if (bl.getRank() >= (Integer)CommonConfig.zealotBrightAreaDamageMultiplierRank.get() && brightness >= (Integer)CommonConfig.zealotBrightAreaDamageMultiplierLightLevel.get()) {
                    event.setAmount(event.getAmount() * ((Double)CommonConfig.zealotBrightAreaDamageMultiplier.get()).floatValue());
                }
                if (skillHandler == null || skillHandler.isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_HEX_PROTECTION.get()) && (event.getSource().is(DamageTypes.MAGIC) || event.getSource().is(DamageTypes.INDIRECT_MAGIC))) {
                    event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.zealotHexProtectionMultiplier.get()).get(rank)).floatValue());
                }
            }
            if (bl.getBloodline() instanceof BloodlineFrost) {
                if (event.getSource().is(ModDamageTypes.VAMPIRE_IN_FIRE) || event.getSource().is(ModDamageTypes.VAMPIRE_ON_FIRE)) {
                    event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.ectothermFireDamageMultipliers.get()).get(rank)).floatValue());
                }
                if ((skillHandler == null || skillHandler.isSkillEnabled((ISkill)BloodlineSkills.ECTOTHERM_DIFFUSION.get())) && event.getSource().is(ModDamageTypes.HOLY_WATER)) {
                    event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.ectothermHolyWaterDiffusion.get()).get(rank)).floatValue());
                }
            }
            if (bl.getBloodline() instanceof BloodlineBloodknight && (entity3 = event.getSource().getEntity()) instanceof LivingEntity && Helper.isHunter((Entity)(entity2 = (LivingEntity)entity3))) {
                event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.bloodknightHunterDamageMult.get()).get(rank)).floatValue());
            }
        }
    }

    private static void handleLeeching(Player player, float originalAmount, LivingEntity target) {
        VampirePlayer vampirePlayer = VampirePlayer.get((Player)player);
        IVampSpecialAttributes specialAttributes = (IVampSpecialAttributes)vampirePlayer.getSpecialAttributes();
        if (specialAttributes.bloodlines$getLeeching() < 1) {
            return;
        }
        float amt = Math.min(2.0f, originalAmount * ((Double)CommonConfig.leechingMultiplier.get()).floatValue());
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            if (!Helper.isVampire((Player)targetPlayer)) {
                targetPlayer.getFoodData().addExhaustion(amt);
            } else {
                vampirePlayer.addExhaustion(amt);
            }
        } else {
            target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 40, 0));
        }
        vampirePlayer.drinkBlood(Math.round(amt), amt * ((Double)CommonConfig.leechingMultiplier.get()).floatValue(), (IDrinkBloodContext)new DrinkBloodContext(target));
        if (specialAttributes.bloodlines$getLeeching() >= 2) {
            player.heal(amt);
        }
    }

    @SubscribeEvent
    public static void livingFallEvent(LivingFallEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isVampire((Player)(player = (Player)livingEntity)) && player.getBlockStateOn().is(BloodlinesTagsProviders.BloodlinesBlockTagProvider.ZEALOT_STONE) && VampirePlayer.get((Player)player).getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_FALL_DAMAGE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFoodEatenFinish(LivingEntityUseItemEvent.Finish event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isVampire((Player)(player = (Player)livingEntity))) {
            VampirePlayer vp = VampirePlayer.get((Player)player);
            if (event.getItem().is(Items.ROTTEN_FLESH) && vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_FLESH_EATING.get())) {
                if (player.getEffect(MobEffects.HUNGER) != null && player.getEffect(MobEffects.HUNGER).getDuration() == 600) {
                    player.removeEffect(MobEffects.HUNGER);
                }
                vp.drinkBlood(((Integer)CommonConfig.zealotFleshEatingNutrition.get()).intValue(), ((Double)CommonConfig.zealotFleshEatingSaturation.get()).floatValue(), (IDrinkBloodContext)new DrinkBloodContext(event.getItem()));
            }
            if (event.getItem().is(BloodlinesTagsProviders.BloodlinesItemTagProvider.ECTOTHERM_RAW_FISH) && vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.FISHMONGER.get())) {
                vp.drinkBlood(((Integer)CommonConfig.ectothermFishmongerNutrition.get()).intValue(), ((Double)CommonConfig.ectothermFishmongerSaturation.get()).floatValue(), (IDrinkBloodContext)new DrinkBloodContext(event.getItem()));
            }
        }
    }

    @SubscribeEvent
    public static void actionActivatedEvent(ActionEvent.ActionActivatedEvent event) {
        if (event.getAction() instanceof InvisibilityVampireAction) {
            ISkillHandler skillHandler = event.getFactionPlayer().getSkillHandler();
            if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.NOBLE_INVISIBILITY.get()) && skillHandler.isSkillEnabled((ISkill)VampireSkills.VAMPIRE_INVISIBILITY.get())) {
                event.setDuration((Integer)CommonConfig.bothInvisibilityDuration.get() * 20);
            }
        } else if (!(event.getAction() instanceof ILastingAction) && event.getFactionPlayer().getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_SHADOW_MASTERY.get())) {
            Player player = event.getFactionPlayer().asEntity();
            if (BloodlineHelper.lightMatches((Integer)CommonConfig.zealotShadowMasteryLightLevel.get(), player.getOnPos().above(), player.getCommandSenderWorld(), false)) {
                int rank = BloodlineHelper.getBloodlineRank(player) - 1;
                event.setCooldown(Math.round((float)event.getCooldown() * ((Double)((List)CommonConfig.zealotShadowMasteryCooldownMultiplier.get()).get(rank)).floatValue()));
            }
        }
    }

    @SubscribeEvent
    public static void actionDeactivatedEvent(ActionEvent.ActionDeactivatedEvent event) {
        int rank;
        ISkillHandler skillHandler;
        Player player = event.getFactionPlayer().asEntity();
        if (event.getAction() instanceof InvisibilityVampireAction && (skillHandler = event.getFactionPlayer().getSkillHandler()).isSkillEnabled((ISkill)BloodlineSkills.NOBLE_INVISIBILITY.get()) && skillHandler.isSkillEnabled((ISkill)VampireSkills.VAMPIRE_INVISIBILITY.get())) {
            event.setCooldown((Integer)CommonConfig.bothInvisibilityCooldown.get() * 20);
        }
        if (event.getFactionPlayer().getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_SHADOW_MASTERY.get()) && BloodlineHelper.lightMatches((Integer)CommonConfig.zealotShadowMasteryLightLevel.get(), player.getOnPos().above(), player.getCommandSenderWorld(), false)) {
            int rank2 = BloodlineHelper.getBloodlineRank(player) - 1;
            event.setCooldown(Math.round((float)event.getCooldown() * ((Double)((List)CommonConfig.zealotShadowMasteryCooldownMultiplier.get()).get(rank2)).floatValue()));
        }
        if (player.level().getBiome(player.getOnPos()).is(Tags.Biomes.IS_HOT) && BloodlineManager.get(event.getFactionPlayer().asEntity()).getBloodline() instanceof BloodlineFrost && (rank = BloodlineManager.get(player).getRank() - 1) >= (Integer)CommonConfig.ectothermHotBiomeActionCooldownRank.get()) {
            event.setCooldown(Math.round((float)event.getCooldown() * ((Double)((List)CommonConfig.ectothermHotBiomeActionCooldownMultiplier.get()).get(rank)).floatValue()));
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        BloodlineManager bloodlineManager = BloodlineManager.get(event.getEntity());
        if (bloodlineManager.getBloodline() instanceof BloodlineZealot) {
            int rank = bloodlineManager.getRank() - 1;
            float additionalSpeed = 0.0f;
            if (event.getState().is(BloodlinesTagsProviders.BloodlinesBlockTagProvider.ZEALOT_STONE) && VampirePlayer.get((Player)event.getEntity()).getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_TUNNELER.get())) {
                additionalSpeed = ((Double)((List)CommonConfig.zealotTunnelerIncrease.get()).get(rank)).floatValue();
            }
            event.setNewSpeed((event.getOriginalSpeed() + additionalSpeed) * ((Double)((List)CommonConfig.zealotMiningSpeedIncrease.get()).get(rank)).floatValue());
        }
    }

    @SubscribeEvent
    public static void interact(PlayerInteractEvent.RightClickEmpty event) {
        IVampSpecialAttributes specialAttributes;
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        HitResult result = event.getEntity().pick(10.0, 1.0f, true);
        if (!(result instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockResult = (BlockHitResult)result;
        Player player = event.getEntity();
        BlockPos eyePos = BlockPos.containing((Position)player.getEyePosition());
        Level level = event.getLevel();
        if (level.getBlockState(eyePos).is(Blocks.WATER)) {
            return;
        }
        BlockPos pos = blockResult.getBlockPos();
        if (level.getBlockState(pos).is(Blocks.WATER) && (specialAttributes = (IVampSpecialAttributes)VampirePlayer.get((Player)event.getEntity()).getSpecialAttributes()).bloodlines$getIcePhasing() && specialAttributes.bloodlines$getFrostControl()) {
            Minecraft.getInstance().getConnection().send((CustomPacketPayload)ServerboundIcePacket.getInstance());
        }
    }

    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        Player player;
        LivingEntity living = event.getEntity();
        if (living instanceof Player && Helper.isVampire((Player)(player = (Player)living))) {
            BloodlineEventHandler.removeBloodknightBatMult(player);
        }
    }

    public static void onEffectExpired(MobEffectEvent.Expired event) {
        Player player;
        LivingEntity living = event.getEntity();
        if (living instanceof Player && Helper.isVampire((Player)(player = (Player)living))) {
            BloodlineEventHandler.removeBloodknightBatMult(player);
        }
    }

    private static void removeBloodknightBatMult(Player player) {
        VampirePlayer vp = VampirePlayer.get((Player)player);
        if (vp.getSpecialAttributes().bat && !vp.getActionHandler().isActionActive((ILastingAction)BloodlineActions.BLOODKNIGHT_SANGUINE_INFUSION.get())) {
            player.getAbilities().setFlyingSpeed(((Double)VampirismConfig.BALANCE.vaBatFlightSpeed.get()).floatValue());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Spider) {
            BloodlineEventHandler.makeZealotFriendly("spider", (Spider)event.getEntity(), Spider.SpiderTargetGoal.class, Player.class, 2, type -> type == EntityType.SPIDER || type == EntityType.CAVE_SPIDER);
        }
    }

    public static <T extends Mob, S extends LivingEntity, Q extends NearestAttackableTargetGoal<S>> void makeZealotFriendly(String name, @NotNull T e, @NotNull Class<Q> targetClass, @NotNull Class<S> targetEntityClass, int attackPriority, @NotNull Predicate<EntityType<? extends T>> typeCheck) {
        Goal target = null;
        for (WrappedGoal t : ((GoalSelectorAccessor)e.targetSelector).getAvailableGoals()) {
            Goal g = t.getGoal();
            if (!targetClass.equals(g.getClass()) || t.getPriority() != attackPriority || !targetEntityClass.equals(((NearestAttackableTargetGoalAccessor)g).getTargetType())) continue;
            target = g;
            break;
        }
        if (target != null) {
            EntityType type = e.getType();
            if (typeCheck.test(type)) {
                ((ZealotTargetGoalModifier)target).ignoreZealotSpiderFriend();
            }
        } else if (entityAIReplacementWarnMap.getOrDefault((Object)name, true)) {
            Bloodlines.LOGGER.warn("Could not modify {} attack target task for {}", (Object)name, (Object)e.getType().getDescription());
            entityAIReplacementWarnMap.put((Object)name, false);
        }
    }
}

